<?php

namespace App\Jobs;

use App\Command\Log;
use App\Models\OrderDivideRecord;
use App\Models\OrderInfo;
use App\Models\PaymentRecord;
use App\Models\StoreAdminUsers;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Exception;

class AutoOrderDivide implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $um_id; //推广人员ID
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($um_id, $delay)
    {
        $this->um_id = $um_id;
        // 设置延迟的时间，delay() 方法的参数代表多少秒之后执行
        $this->delay($delay);
    }

    /**
     * * 定义这个任务类具体的执行逻辑
     * 当队列处理器从队列中取出任务时，会调用 handle() 方法
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $payment_confirm = new \NwVVVS\AdapaySdk\PaymentConfirm(); //支付确认
        $spObj = StoreAdminUsers::find($this->um_id);
        $member_id = $spObj->member_id;
        $chunkSize = 10; // 每次处理数量
        $orders = OrderDivideRecord::where(['um_id' => $member_id, 'is_div' => 0])->whereIn('sh_type', [5])->orderBy('id')->take($chunkSize);
        
        Log::add('AutoOrderDivide', ['member_id' => $member_id, 'count' => $orders->count(),'um_id' => $this->um_id]);
        
        while ($orders->count() > 0) {
            $orders->chunk($chunkSize, function ($batch) use ($member_id, $payment_confirm) {
                foreach ($batch as $item) {
                    //交易记录
                    $order_sn = OrderInfo::where('id', $item->order_id)->value('order_sn');
                    $prObj = PaymentRecord::where('order_sn', $order_sn)->first();
                    # 支付确认参数设置
                    $payment_params = array(
                        "payment_id" => $prObj->payment_id,
                        "order_no" => 'payconfirm_' . date("YmdHis") . rand(100000, 999999),
                        "confirm_amt" => $item->divide_price,
                        "description" => "",
                        "div_members" => "" //分账参数列表 默认是数组List
                    );
                    // 分账列表-[每次分账请求，必须有且只能有一个分账方为手续费承担方]
                    $payment_params['div_members'] = [
                        'member_id' => $member_id,
                        'amount' => $item->divide_price,
                        'fee_flag' => 'Y'
                    ];


                    //分账参数打印
                    Log::add('payment_params', $payment_params);

                    # 发起支付确认创建
                    $payment_confirm->create($payment_params);
                    # 对支付确认创建结果进行处理
                    if ($payment_confirm->isError()) {
                        //失败处理
                        Log::add('用户绑卡,支付确认失败', $payment_confirm->result);
                        $result = $payment_confirm->result;
                        //throw new Exception($result['error_msg']);//手续费承担方有且只能有一个,给平台承担
                    } else {
                        //成功处理
                        Log::add('支付确认成功', $payment_confirm->result);
                        $result = $payment_confirm->result;
                        if ($result['status'] == 'succeeded') {
                            $item->is_div = 1;
                            $item->payconfirm_no = $result['order_no'];
                            $item->save();
                            Log::add('分账成功', ['order_sn' => $order_sn, 'member_id' => $member_id]);
                        }
                    }
                }
            });

            // 移动游标到下一批
            $orders->skip($chunkSize);
            $orders = $orders->getQuery();
            sleep(2);
        }
    }
}
