<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\UserCollect;
use App\Models\Good as GoodModel;
use App\Models\GoodSku;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UserCollectController extends BaseController
{
    public function collectOpt(Request $request)
    {
        $gid = $request->goods_id ?? 0;
        $userid = $request->user()->id;
        if (!GoodModel::find($gid)) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        DB::beginTransaction();
        try {
            $userAppreciate = UserCollect::where(['goods_id' => $gid, 'uid' => $userid])->first();
            if ($userAppreciate) {
                $userAppreciate->delete();
            } else {
                $userAppreciate = UserCollect::withTrashed()->where(['goods_id' => $gid, 'uid' => $userid])->first();
                if ($userAppreciate) {
                    $userAppreciate->deleted_at = null;
                    $userAppreciate->save();
                } else {
                    $model = new UserCollect();
                    $model->goods_id = $gid;
                    $model->uid = $userid;
                    $model->save();
                }
            }
            DB::commit();
        } catch (\Exception $e) {
            Log::add('用户收藏失败', $e->getMessage());
            DB::rollBack();
        }

        return $this->JsonResponse('');
    }

    public function collectList(Request $request)
    {
        $userObj = $request->user();
        $user_id = $userObj->id;
        $merchant_id = $userObj->merchant_id;
        $buycode = $request->buycode ?? null; //直购码，不传即原价购买


        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;
        $sql = UserCollect::where(['uid' => $user_id, 'deleted_at' => null]);
        $data = [
            'total' => $sql->count(),
            'total_page' => ceil($sql->count() / $limit),
            'list' => []
        ];
        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $datum) {
                $goods_id = $datum->goods_id;
                $goodObj = GoodModel::select(['goods_name', 'cover_img', 'tags'])->find($goods_id);
                $attrRowObj = GoodSku::where("goods_id", $goods_id)->first();
                $tags = $goodObj->tags ? json_decode($goodObj->tags, true) : [];
                $data['list'][] = [
                    'goods_id' => $goods_id,
                    'goods_name' => $goodObj->goods_name ?? '',
                    'attr' => $attrRowObj ? $attrRowObj->attr_val  : '',
                    'tags' => $tags,
                    'goods_price' => $buycode ? sprintf("%.2f", $attrRowObj->cg_price) : sprintf("%.2f", $attrRowObj->market_price),
                    'dg_price' => sprintf('%.2f', $attrRowObj->cg_price),
                    'market_price' => sprintf('%.2f', $attrRowObj->market_price),
                    'cover_img' => ($goodObj->cover_img ? togetherFilePath($goodObj->cover_img) : ''),
                    'addtime' => date('Y-m-d H:i:s', strtotime($datum->created_at))
                ];
            }
        }

        return  $this->JsonResponse($data);
    }
}
