<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use Illuminate\Http\Request;
use App\Models\Adapay;
use App\Models\HfCompanyMember;
use App\Models\HfSettleAccount;
use App\Jobs\AutoOrderDivide;
use Exception;
use Illuminate\Support\Facades\DB;

class HfSettleAccountController extends BaseController
{
    //创建普通用户结算账户
    public function createMemberAccount(Request $request)
    {
        $card_id = $request->card_id ?? '';
        $card_name = $request->card_name ?? '';
        $tel_no = $request->tel_no ?? '';
        $cert_id = $request->cert_id ?? '';
        if (!$card_id || !$card_name || !$tel_no || !$cert_id) {
            return $this->JsonResponse('', '必填项不为空', 500);
        }
        $userObj = $request->user();
        $user_id = $userObj->id;
        $member_id = $userObj->member_id;
        if (!$member_id) {
            return $this->JsonResponse('', '账户异常，请联系管理员', 500);
        }
        $account_params = array(
            "app_id" => env('HUIFU_APPID'),
            "member_id" => $member_id,
            "channel" => "bank_account",
            "account_info" => [
                "card_id" => $card_id,
                "card_name" => $card_name,
                "cert_id" => $cert_id,
                "cert_type" => "00",
                "tel_no" => $tel_no,
                "bank_acct_type" => "2",
            ]
        );
        $local_params = [
            'member_type' => 0,
            'mid' => $user_id,
            'card_id' => $card_id,
            'card_name' => $card_name,
            'cert_id' => $cert_id,
            'cert_type' => '00',
            'tel_no' => $tel_no,
            'bank_acct_type' => 2
        ];

        DB::beginTransaction();
        try {
            # 创建
            $result = (new Adapay())->createMemberSettleAccount($account_params);
            if (isset($result['status']) && $result['status'] == 'succeeded') {
                $local_params['account_id'] = $result['id'];
                $local_params['created_at'] = date("Y-m-d H:i:s", $result['create_time']);
                DB::table('hf_settle_account')->insert($local_params);
                //发起分账
                $this->dispatch(new AutoOrderDivide($user_id, 10));
            } else {
                throw new Exception($result['error_msg']);
            }

            DB::commit();
            return $this->JsonResponse('');
        } catch (\Exception $exception) {
            Log::add('添加用户结算账户失败', $exception->getMessage());
            DB::rollBack();
            return $this->JsonResponse('', $exception->getMessage(), 500);
        }
    }

    //创建企业用户结算账户
    public function createCompanyAccount(Request $request)
    {
        $card_id = $request->card_id ?? '';
        $card_name = $request->card_name ?? '';
        $tel_no = $request->tel_no ?? '';
        $bank_code = $request->bank_code ?? '';
        $bank_name = $request->bank_name ?? '';
        $prov_code = $request->prov_code ?? '';
        $area_code = $request->area_code ?? '';
        if (!$card_id || !$card_name || !$tel_no || !$bank_code || !$prov_code || !$area_code) {
            return $this->JsonResponse('', '必填项不为空', 500);
        }
        $userObj = $request->user();
        $merchant_id = 3; //$userObj->merchant_id;
        $exist = HfCompanyMember::where(['merchant_id' => $merchant_id, 'member_id' => 'cm_id' . $merchant_id])->count();
        if (!$exist) {
            return $this->JsonResponse('', '账户异常，请联系管理员', 500);
        }
        $member_id = 'cm_id' . $merchant_id;
        $account_params = array(
            "app_id" => env('HUIFU_APPID'),
            "member_id" => $member_id,
            "channel" => "bank_account",
            "account_info" => [
                "card_id" => $card_id,
                "card_name" => $card_name,
                "tel_no" => $tel_no,
                "bank_code" => $bank_code,
                "bank_name" => $bank_name,
                "bank_acct_type" => "1",
                "prov_code" => $prov_code,
                "area_code" => $area_code,
            ]
        );
        $local_params = [
            'member_type' => 1,
            'mid' => $merchant_id,
            'card_id' => $card_id,
            'card_name' => $card_name,
            "bank_code" => $bank_code,
            "bank_name" => $bank_name,
            'tel_no' => $tel_no,
            'bank_acct_type' => 1,
            "prov_code" => $prov_code,
            "area_code" => $area_code,
        ];

        DB::beginTransaction();
        try {
            # 创建
            $result = (new Adapay())->createMemberSettleAccount($account_params);
            if (isset($result['status']) && $result['status'] == 'succeeded') {
                $local_params['account_id'] = $result['id'];
                $local_params['created_at'] = date("Y-m-d H:i:s", $result['create_time']);
                DB::table('hf_settle_account')->insert($local_params);
            } else {
                throw new Exception($result['error_msg']);
            }

            DB::commit();
            return $this->JsonResponse('');
        } catch (\Exception $exception) {
            Log::add('添加用户结算账户失败' . $member_id, $exception->getMessage());
            DB::rollBack();
            return $this->JsonResponse('', $exception->getMessage(), 500);
        }
    }

    //查询已绑定结算账户
    public function myCard(Request $request)
    {
        $userObj = $request->user();
        $member_type = $request->member_type ?? 0;
        $role_id = $userObj->role_id ?? '';

        
        if ($role_id == 1) { //商家
            $mid = $userObj->merchant_id;
            $accountObj = HfCompanyMember::where(['merchant_id' => $mid])->first();

            //直接返回企业用户信息
            if ($accountObj) {

                $account_params = array(
                    'card_id' => $accountObj->name ?? '',
                    'card_name' => $accountObj->cont_name ?? '',
                    'tel_no' => $accountObj->cont_phone ?? '',
                    'bank_code' =>  '',
                    'bank_name' => '',
                );
                return $this->JsonResponse($account_params);
            } else {
                Log::add('myCard', ['msg' => '没有查询到绑卡信息！']);
                return $this->JsonResponse([], '该商户后台数据错误，请联系管理员！', 201);
            }
        } else {
            $mid = $userObj->id;
            $member_id = $userObj->member_id;
        }
        if (!$member_id) {
            return $this->JsonResponse([]);
            //return $this->JsonResponse('', '参数错误', 201);
        }

        $account_params = [];
        $accountObj = HfSettleAccount::where(['member_type' => $member_type, 'mid' => $mid])->first();
        if ($accountObj) {
            $account_params = array(
                'card_id' => $accountObj->card_id ?? '',
                'card_name' => $accountObj->card_name ?? '',
                'tel_no' => $accountObj->tel_no ?? '',
                'bank_code' => $accountObj->bank_code ?? '',
                'bank_name' => $accountObj->bank_name ?? '',
            );
        }

        return $this->JsonResponse($account_params);
    }

    //查询账户余额
    public function queryBalance(Request $request)
    {
        $userObj = $request->user();
        //$member_type = $request->member_type ?? 0;
        $role_id = $userObj->role_id ?? '';
        if ($role_id == 1) { //商家
            $mid = $userObj->merchant_id;
            $member_id = HfCompanyMember::where(['merchant_id' => $mid, 'status' => 'succeeded'])->value('member_id');
        } else {
            $mid = $userObj->id;
            $member_id = $userObj->member_id;
        }
        if (!$member_id) {
            return $this->JsonResponse('', '账户异常，请联系管理员', 500);
        }

        $account_params = [
            'app_id' => env('HUIFU_APPID'),
            'member_id' => $member_id,
        ];
        $result = (new Adapay())->queryBalance($account_params);
        if (isset($result['status']) && $result['status'] == 'succeeded') {
            return $this->JsonResponse($result);
        } else {
            return $this->JsonResponse('', '查询失败', 201);
        }
    }

    //银行代码
    public function getBankCode()
    {
        $data = [
            ['code' => '01020000', 'title' => '工商银行'],
            ['code' => '01030000', 'title' => '农业银行'],
            ['code' => '01040000', 'title' => '中国银行'],
            ['code' => '01050000', 'title' => '建设银行'],
            ['code' => '03010000', 'title' => '交通银行'],
            ['code' => '03134402', 'title' => '平安银行'],
            ['code' => '03020000', 'title' => '中信银行'],
            ['code' => '03030000', 'title' => '光大银行'],
            ['code' => '03040000', 'title' => '华夏银行'],
            ['code' => '03050000', 'title' => '民生银行'],
            ['code' => '03060000', 'title' => '广发银行'],
            ['code' => '03080000', 'title' => '招商银行'],
            ['code' => '03090000', 'title' => '兴业银行'],
            ['code' => '03100000', 'title' => '浦发银行'],
            ['code' => '03130011', 'title' => '北京银行'],
            ['code' => '03130012', 'title' => '天津银行'],
            ['code' => '03130031', 'title' => '上海银行'],
            ['code' => '03130032', 'title' => '江苏银行'],
            ['code' => '03130050', 'title' => '重庆银行'],
            ['code' => '03132102', 'title' => '大连银行'],
            ['code' => '03132301', 'title' => '哈尔滨银行'],
            ['code' => '03133201', 'title' => '南京银行'],
            ['code' => '03133301', 'title' => '杭州银行'],
            ['code' => '03133302', 'title' => '宁波银行'],
            ['code' => '03133308', 'title' => '温州银行'],
            ['code' => '03150000', 'title' => '恒丰银行'],
            ['code' => '03160000', 'title' => '浙商银行'],
        ];
        return $this->JsonResponse($data);
    }

    //删除结算账户
    public function deleteAccount(Request $request)
    {
        $userObj = $request->user();
        $member_type = $request->member_type ?? 0;
        $role_id = $userObj->role_id ?? '';
        if ($role_id == 1) { //商家
           //商家不允许删除和添加，请去后台操作审核
           Log::add('deleteAccount', ['msg' => '商家不允许删除和添加，请去后台操作审核！']);
           return $this->JsonResponse('', '商家不允许删除和添加银行卡，请去后台申请管理员操作！', 201);

        } else {
            $mid = $userObj->id;
            $member_id = $userObj->member_id;
        }
        if (!$member_id) {
            return $this->JsonResponse('', '参数错误', 201);
        }


        $accountObj = HfSettleAccount::where(['member_type' => $member_type, 'mid' => $mid])->first();
        $account_params = array(
            'app_id' => env('HUIFU_APPID'),
            'member_id' => $member_id,
            'settle_account_id' => $accountObj->account_id
        );

        # 删除
        $result = (new Adapay())->deleteSettleAccount($account_params);
        if (isset($result['status']) && $result['status'] == 'succeeded') {
            //删除本地
            $accountObj->delete();
            return $this->JsonResponse('');
        } else {
            return $this->JsonResponse('', '删除失败', 201);
        }
    }
}
