<?php

namespace App\Http\Controllers\Api;

use App\Models\OrderDivideRecord;
use App\Models\Adapay;
use App\Command\Log;
use App\Handlers\QqCos;
use App\Handlers\FileUploadHandler;
use App\Models\Carousel;
use App\Models\User;
use App\Models\UserPermission;
use Illuminate\Http\Request;

class CarouselController extends BaseController
{
    public function getList()
    {
        $list = (new Carousel())->select("id", "imgUrl", "title", "status")
            ->where("status", 1)
            ->orderBy("id", "desc")
            ->limit(9)
            ->get();

        foreach ($list as $key => $val) {
            $list[$key]['imgUrl'] = ($val->imgUrl ? $val->imgUrl : "");
        }

        // 从.env文件中获取is_examine的值，如果不存在则默认为0
        $is_examine = env('IS_EXAMINE', 0);

        $data['info'] = $list;
        $data['is_examine'] = $is_examine;

        return  $this->JsonResponse($data);
    }
    //测试订单分佣
    public function orderDiv(Request $request)
    {
        $order_id = $request->order_id ?? 0;

        //分账列表
        $payment_params = OrderDivideRecord::divide($order_id); //返回分账参数列表
        return  $this->JsonResponse($payment_params);
    }

    
    //测试订单积分生成
    public function orderDivByPoint(Request $request)
    {
        $order_id = $request->order_id ?? 0;

        //分账列表
        $payment_params = Adapay::createPointRecordByOrder($order_id); //返回分账参数列表
        return  $this->JsonResponse($payment_params);
    }
}
