<?php
namespace App\Command;
use Illuminate\Http\Response;

class  Tools{
    /**
     * @param $data mixed 返回的数据
     * @param $msg string 状态码
     * @param $code int 返回的自定义信息
     * @return Response
     */
    public static function JsonResponse($data, string $msg = 'Success', int $code = 200): Response
    {
        //组建返回结果
        $result = [
            'code' => $code,
            'message' => $msg,
            'data' => $data,
        ];
        return response($result, 200);
    }

    // 计算俩地距离
    function get_two_point_distance($lat1,$lng1,$lat2,$lng2)
    {
        $radLat1 = deg2rad($lat1);//deg2rad()函数将角度转换为弧度
        $radLat2 = deg2rad($lat2);
        $radLng1 = deg2rad($lng1);
        $radLng2 = deg2rad($lng2);
        $a = $radLat1 - $radLat2;
        $b = $radLng1 - $radLng2;
        $s = 2 * asin(sqrt(pow(sin($a / 2), 2) + cos($radLat1) * cos($radLat2) * pow(sin($b / 2), 2))) * 6378.137;
        return round($s,2);//返回公里数
    }

    // 新增结算日期计算方法
    public static function calculateSettlementDate(\Carbon\Carbon $date)
    {
        // 在原有的 T + 1 基础上额外加 5 小时
        $settlementDate = $date->copy()->addDay()->addHours(5);
        // 跳过周末（需补充节假日判断）
        while ($settlementDate->isWeekend()) {
            $settlementDate->addDay();
        }
        return $settlementDate;
    }

    // 计算 T+1 未到账金额
    public static function calculatePendingCashout($merchant_id)
    {
        return \App\Models\OrderDivideRecord::where('um_id', $merchant_id)
            ->get()
            ->filter(function ($record) {
                $createdAt = $record->created_at;
                $settlementDate = self::calculateSettlementDate($createdAt);
                // 修改为通过秒来判断
                return now()->timestamp <= $settlementDate->timestamp; 
            })->sum('divide_price');
    }
}
