<?php

namespace App\Admin\Metrics\Examples;

use App\Models\OrderInfo as OrderInfoModel;
use Dcat\Admin\Widgets\Metrics\Round;
use Dcat\Admin\Widgets\Metrics\Line;
use Illuminate\Http\Request;

class OrderTotal extends Line
{
    /**
     * 初始化卡片内容
     */
    protected function init()
    {
        parent::init();

        $this->title('订单量');
        $this->dropdown([
            '1' => '今天',
            '7' => '最近7天',
            '30' => '最近30天',
            '365' => '最近一年',
        ]);
        //$this->chartLabels(['Finished', 'Pending', 'Rejected']);
        // $this->dropdown([
        //     '7' => 'Last 7 Days',
        //     '28' => 'Last 28 Days',
        //     '30' => 'Last Month',
        //     '365' => 'Last Year',
        // ]);
    }

    /**
     * 处理请求
     *
     * @param Request $request
     *
     * @return mixed|void
     */
    public function handle(Request $request)
    {
        switch ($request->get('option')) {
            case '365':
                $data = OrderInfoModel::getYearData();
                // 卡片内容
                $this->withContent($data['total']);
                // 图表数据
                $this->withChart($data['list']);
                break;
            case '30':
                $data = OrderInfoModel::getNumDayData(30);
                // 卡片内容
                $this->withContent($data['total']);
                // 图表数据
                $this->withChart($data['list']);
                break;
            case '7':
                $data = OrderInfoModel::getNumDayData(7);
                // 卡片内容
                $this->withContent($data['total']);
                // 图表数据
                $this->withChart($data['list']);
                break;
            default:
                $data = OrderInfoModel::getNumDayData(1);
                // 卡片内容
                $this->withContent($data['total']);
                // 图表数据
                $this->withChart($data['list']);
        }
    }

    /**
     * 设置图表数据.
     *
     * @param array $data
     *
     * @return $this
     */
    public function withChart(array $data)
    {


        $series_data = [];
        foreach ($data as $v) {
            $series_data[] = $v;
        }
        return $this->chart([
            'series' => [
                [
                    'name' => '订单量',
                    'data' => $series_data,
                ],
            ],
            'stroke' => [
                'curve' => 'smooth'
            ],
        ]);
    }

    /**
     * 设置卡片内容.
     *
     * @param string $content
     *
     * @return $this
     */
    public function withContent($content)
    {
        return $this->content(
            <<<HTML
<div class="d-flex justify-content-between align-items-center mt-1" style="margin-bottom: 2px">
    <h2 class="ml-1 font-lg-1">{$content}</h2>
    <span class="mb-0 mr-1 text-80">{$this->title}</span>
</div>
HTML
        );
    }
}
