<?php

namespace App\Admin\Forms;

use App\Models\OrderInfo;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use App\Http\Controllers\Api\SystemSettingController;



class VerifierCodeForm extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {
        $code = trim($input['verification_code']);
        $exist = OrderInfo::where('verification_code', $code)->count();
        if ($exist) {
            return $this->response()->error('该核销码已存在')->refresh();
        }
        $order = OrderInfo::find($this->payload['id']);
        $order->order_status = 2; //待领取状态
        $order->verification_code = $code;
        $order->verifi_code_at = date("Y-m-d H:i:s");

        //生成核销码二维码,保存路径到数据库，后面直接返回前端
        $path = SystemSettingController::GetQrCode($order->verification_code);
        $order->verification_code_img = $path;

        $order->save();
        return $this->response()->success('确认成功')->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $code = date('Ymd') . mt_rand(1000, 9999) . substr(implode("", array_map('ord', str_split(substr(uniqid(), 7, 13), 1))), 0, 8);
        $this->text('verification_code', '核销码')->default($code);
        //$this->radio('status', '状态')->options([1 => '通过', 2 => '驳回'])->default(1)->required();
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        // 获取外部传递参数
        return [];
    }
}
