<?php

namespace App\Admin\Forms;

use App\Command\Log;
use App\Models\StoreAdminUsers as  StoreEmployee;
use App\Models\StoreEmployeeUserRec;
use App\Models\User;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Illuminate\Support\Facades\DB;

class EmployeeForm extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * 处理表单请求
     * 功能：保存用户与员工的关联关系
     * 参数：$input 表单提交数据
     * 返回值：mixed 操作结果
     * 异常：数据库操作异常
     */
    public function handle(array $input)
    {
        $userId = $this->payload['id'];
        $employeeId = $input['employee_id'];
        
        DB::beginTransaction();
        try {
            // 删除原有关联
            StoreEmployeeUserRec::where('user_id', $userId)->delete();
            
            // 创建新关联
            $result = StoreEmployeeUserRec::create([
                'user_id' => $userId,
                'employee_id' => $employeeId,
                'created_at' => now()
            ]);
            
            if (!$result) {
                throw new \Exception('创建关联记录失败');
            }
            
            DB::commit();
            Log::Add('debug', "用户{$userId}分配员工{$employeeId}成功");
            
            return $this->response()
                ->success('分配成功')
                ->refresh();
        } catch (\Exception $e) {
            DB::rollBack();
            Log::Add('error', "员工分配失败: ".$e->getMessage());
            return $this->response()
                ->error('分配失败: '.$e->getMessage());
        }
    }

    /**
     * 构建表单
     * 功能：创建员工选择表单
     * 参数：无
     * 返回值：void
     * 注意事项：根据buycode筛选员工
     */
    public function form()
    {
        /**
         * 构建表单
         * 功能：创建员工选择表单
         * 参数：无
         * 返回值：void
         * 注意事项：根据buycode筛选员工
         */
        $buycode = $this->payload['buycode'] ?? null;
        
        $this->select('employee_id', '选择员工')
            ->options(function () use ($buycode) {
                $query = StoreEmployee::where('role_id', 3);
                
                if ($buycode) {
                    $query->whereHas('merchant', function($q) use ($buycode) {
                        $q->where('buycode', $buycode);
                    });
                }
                
                return $query->get()->pluck('name', 'id');
            })
            ->required()
            ->rules('required');
    }

    /**
     * 表单默认数据
     * 返回值：array 空数组
     */
    public function default()
    {
        return [];
    }
}
