<?php

namespace App\Admin\Controllers;

use App\Command\Log;
use App\Models\HfCompanyMember;
use App\Models\HfProvAreaCode;
use App\Models\Adapay;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Card;
use App\Models\Merchant;
use Illuminate\Support\Facades\DB;

class HfCompanyMemberController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new HfCompanyMember(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->model()->orderBy('created_at', 'DESC');
            //$grid->column('order_no');
            $grid->column('cont_name', '联系人姓名');
            $grid->column('cont_phone', '手机号');
            //$grid->column('email');
            $grid->column('entry_mer_type')->display(function ($val) {
                return $val == 1 ? '企业' : '个体工商户';
            });
            $grid->column('social_credit_code');
            $grid->column('name');
            $grid->column('social_credit_code_begin');
            $grid->column('social_credit_code_expires');
            $grid->column('address');
            $grid->column('business_scope')->display('点击查看')->modal(function ($modal) {
                //设置弹窗标题
                $modal->title('经营范围');
                $content = $this->business_scope . "<br/>";
                $card = new Card(null, $content);

                return "<div style='padding:10px 10px 0;width:100%;'>$card</div>";
            });
            $grid->column('legal_person', '法人信息')->display('点击查看')->modal(function ($modal) {
                //设置弹窗标题
                $modal->title('法人信息');
                $content = '法人姓名：' . $this->legal_person . "<br/>";
                $content .= '法人身份证号：' . $this->legal_cert_id . "<br/>";
                $content .= '法人证件有效期起始日期：' . $this->legal_cert_id_begin . "<br/>";
                $content .= '法人证件有效期截止日期：' . $this->legal_cert_id_expires . "<br/>";
                $content .= '法人手机号：' . $this->legal_mp . "<br/>";
                $card = new Card(null, $content);

                return "<div style='padding:10px 10px 0;width:100%;'>$card</div>";
            });
            $grid->column('status', '审核状态')->display(function ($val) {
                $str = '等待审核';
                if ($val == 'failed') {
                    $str = '拒绝';
                } elseif ($val == 'succeeded') {
                    $str = '通过';
                }
                return $str;
            });
            $grid->column('audit_desc', '审核原因')->display('点击查看')->modal(function ($modal) {
                //设置弹窗标题
                $modal->title('审核原因');
                $content = $this->audit_desc . "<br/>";
                $card = new Card(null, $content);

                return "<div style='padding:10px 10px 0;width:100%;'>$card</div>";
            });


            $grid->disableViewButton();
            $grid->disableDeleteButton();
            $grid->disableRowSelector();

            $grid->actions(function (Grid\Displayers\Actions $actions) {
                $rowData = $actions->row;
                if ($rowData['status'] != 'failed') {
                    $actions->disableEdit();
                }
            });

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('cont_name', '联系人姓名')->width(3);
                $filter->like('cont_phone')->width(3);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new HfCompanyMember(), function (Show $show) {
            $show->field('id');
            $show->field('order_no');
            $show->field('cont_name');
            $show->field('cont_phone');
            $show->field('email');
            $show->field('entry_mer_type');
            $show->field('social_credit_code');
            $show->field('name');
            $show->field('social_credit_code_begin');
            $show->field('social_credit_code_expires');
            $show->field('address');
            $show->field('business_scope');
            $show->field('legal_cert_type');
            $show->field('legal_cert_id');
            $show->field('legal_person');
            $show->field('legal_cert_id_begin');
            $show->field('legal_cert_id_expires');
            $show->field('legal_mp');
            $show->field('attach_file');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form =  Form::make(new HfCompanyMember(), function (Form $form) {
            $form->display('id');
            //$form->text('order_no');
            $form->select('merchant_id', '商家名称')
                ->options(Merchant::whereNull('deleted_at')->get()->pluck('name', 'id'))->required();
            // $order_no = 'cm' . date("YmdHis") . mt_rand(10000, 99999);
            // $form->text('order_no')->default($order_no); //请求订单号
            $form->text('cont_name')->required();
            $form->text('cont_phone')->required();
            $form->text('email')->required();
            $form->radio('entry_mer_type')->options(['0' => '个体工商户', '1' => '企业'])->default(1);
            $form->text('social_credit_code')->required()->help('示例值：91310104660736427E');
            $form->text('name')->required()->help('示例值：上海汇付支付有限公司');
            $form->select('prov_code', '省份')->options(HfProvAreaCode::where('parent_id', 0)->pluck('title', 'area_code'))->rules('required')->load('area_code', '/hf-area-code');
            // 城市
            $form->select('area_code', '城市')->required();
            $form->text('social_credit_code_begin')->required()->help('示例值：20220427');
            $form->text('social_credit_code_expires')->required()->help('示例值：20270427');
            $form->text('address')->required();
            $form->text('business_scope')->required();
            $form->hidden('legal_cert_type')->default('00');
            $form->text('legal_cert_id', '法人身份证号码')->required();
            $form->text('legal_person')->required();
            $form->text('legal_cert_id_begin')->required()->help('示例值：20170428');
            $form->text('legal_cert_id_expires')->required()->help('示例值：20370428');
            $form->text('legal_mp')->required();
            $form->file('attach_file', '附件')
                ->url('upload/huifu')
                ->deleteUrl('upload/delete-public-oss-file')
                ->autoUpload()
                ->required()
                ->help('内容须包含三证合一证件照、法人身份证正面照、法人身份证反面照、开户银行许可证照。 压缩 zip包后上传，最大限制为 9 M'); //hf
            $form->text('bank_code', '开户银行编码')->required()->help('示例值：01020000 <a href="https://cloudpnrcdn.oss-cn-shanghai.aliyuncs.com/Adapay/prod/common/documents/Adapay%E6%94%AF%E6%8C%81%E9%93%B6%E8%A1%8C%E5%88%97%E8%A1%A8.xlsx" target="_blank">银行代码表</a>');
            $form->text('card_no', '银行卡号(对公)')->required();
            $form->text('card_name', '银行卡对应的户名')->required();
            $form->hidden('audit_state');
            $form->hidden('audit_desc');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();

            // $form->display('created_at');
            // $form->display('updated_at');
        });

        //汇付注册企业用户
        $form->saved(
            function (Form $form, $result) {
                $hf_id = $form->getKey();
                $params = $_POST ?? [];
                $member_params = array(
                    # app_id
                    "app_id" => env('HUIFU_APPID'),
                    # 商户用户id
                    "member_id" => "cm_id" . $params['merchant_id'],
                    # 订单号
                    "order_no" => 'corp_member' . date("YmdHis") . mt_rand(10000, 99999),
                    # 企业名称
                    "name" => $params['name'],
                    'prod_mode' => false,
                    # 省份
                    "prov_code" => $params['prov_code'],
                    # 地区
                    "area_code" => $params['area_code'],
                    # 统一社会信用码
                    "social_credit_code" => $params['social_credit_code'],
                    "social_credit_code_expires" => $params['social_credit_code_expires'],
                    # 经营范围
                    "business_scope" => $params['business_scope'],
                    # 证件类型
                    "legal_cert_type" => '00',
                    # 法人姓名
                    "legal_person" => $params['legal_person'],
                    # 法人身份证号码
                    "legal_cert_id" => $params['legal_cert_id'],
                    # 法人身份证有效期
                    "legal_cert_id_expires" => $params['legal_cert_id_expires'],
                    # 法人手机号
                    "legal_mp" => $params['legal_mp'],
                    # 企业地址
                    "address" => $params['address'],
                    # 邮编
                    "zip_code" => "",
                    # 异步通知
                    "notify_url" => env('API_URL') . '/hf-company-member-notify',
                    # 企业邮箱
                    "email" => $params['email'],
                    # 上传附件
                    "attach_file" => new \CURLFile($params['attach_file']),
                    "bank_acct_type" => 1, //结算账户类型 1 对公
                    # 银行卡号
                    "card_no" => $params['card_no'], //如果需要自动开结算账户，本字段必填
                    # 银行卡对应的户名
                    "card_name" => $params['card_name'], //如果需要自动开结算账户，本字段必填
                    #结算账户开户银行编码
                    "bank_code" => $params['bank_code'], //如果需要自动开结算账户，本字段必填
                );

                $result = (new Adapay())->createCompany($member_params);
                Log::add('创建企业用户响应结果', $result);
                if ($result['status'] == 'failed') {
                    DB::table('hf_company_member')->where('id', $hf_id)->delete();
                    return $form->response()->error($result['error_msg']);
                } else {
                    DB::table('hf_company_member')->where('id', $hf_id)->update(['member_id' => $result['member_id'], 'order_no' => $result['order_no'], 'status' => $result['status']]);
                }
            }
        );

        return $form;
    }
}
