<?php

namespace App\Admin\Controllers;

use App\Models\Category;
use App\Command\Tools;
use App\Command\Log;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Layout\Row;
use Dcat\Admin\Tree;
use Dcat\Admin\Http\Controllers\AdminController;
use NwVVVS\AdapaySdk\AdapayTools;

class HfBillDownController extends AdminController
{

    public function index(Content $content)
    {
        return $content->header('对账单下载')
            ->description('csv')
            ->body(function (Row $row) {
                // 移除表单创建逻辑
                // 这里可以添加你想要展示的内容，例如文本信息---
                //$row->column(12, '<p>这是对账单下载页面，请选择合适的操作。</p>');
                // 添加时间选择控件和按钮
                $row->column(3, '<input type="date" class="form-control" id="download-date" />');
                $row->column(6, '<button id="download-button" class="btn btn-primary">下载</button>');
                
                $row->column(12, '<div><br></div>');

                $row->column(12, '<div>下载文件为zip压缩包，解压后获取csv类型的文件，编码格式为UTF-8，若使用Excel打开可能会出现乱码，解决方案请参考 <a href="https://jingyan.baidu.com/article/7082dc1c359cbbe40a89bd3e.html" target="_blank" rel="noopener">Excel打开CSV文件</a> ：</p></div>');

                $row->column(12, '<p>Charge开头的文件为支付对账单，参考 <a href="https://cdn.cloudpnr.com/adapayresource/documents/Adapay%20Charge%E5%AF%B9%E8%B4%A6%E5%8D%95%E6%A8%A1%E7%89%88.csv" target="_blank" rel="noopener">支付对账单模版</a></p>');
                $row->column(12, '<p>Refund开头的文件为退款对账单，参考 <a href="https://cdn.cloudpnr.com/adapayresource/documents/Adapay%20Refund%E5%AF%B9%E8%B4%A6%E5%8D%95%E6%A8%A1%E7%89%88.csv" target="_blank" rel="noopener">退款对账单模版</a></p>');
                $row->column(12, '<p>PaymentConfirm开头的文件为支付确认对账单，参考 <a href="https://cdn.cloudpnr.com/adapayresource/documents/Adapay%20PaymentConfirm%E5%AF%B9%E8%B4%A6%E5%8D%95%E6%A8%A1%E7%89%88.csv" target="_blank" rel="noopener">支付确认对账单模版</a></p>');
                $row->column(12, '<p>Div开头的文件为分账对账单，参考 <a href="https://cloudpnrcdn.oss-cn-shanghai.aliyuncs.com/adapayresource/Div对账单模版.csv" target="_blank" rel="noopener">分账对账单模版</a></p>');
                $row->column(12, '<p>RefundDiv开头的文件为分账退款对账单，参考 <a href="https://cloudpnrcdn.oss-cn-shanghai.aliyuncs.com/adapayresource/RefundDiv对账单模版.csv" target="_blank" rel="noopener">分账退款对账单模版</a></p>');

                // 添加 JavaScript 代码绑定点击事件
                $row->column(
                    12,
                    <<<HTML
                    <script>
                    document.getElementById('download-button').addEventListener('click', function() {
                        var date = document.getElementById('download-date').value;
                        if (date) {
                            fetch('/bill-down-download?date=' + date, {
                                method: 'GET'
                            })
                           .then(response => response.json())
                           .then(data => {
                                console.log(data);
                                // 判断 code 是否为 200
                                if (data.code === 200) {
                                    // 创建一个隐藏的 a 标签
                                    var a = document.createElement('a');
                                    a.href = data.data.url;
                                    a.download = 'downloaded_file.zip'; // 可以根据需要修改文件名
                                    a.style.display = 'none';
                                    document.body.appendChild(a);
                                    a.click();
                                    document.body.removeChild(a);
                                } else {
                                    alert('下载失败:请查看日志 ');
                                }
                            });
                        } else {
                            alert('请选择日期');
                        }
                    });
                    </script>
                    HTML
                );
            });
    }

    /**
     * 处理下载请求
     */
    public function download()
    {
        $date = request()->input('date');
        $date = str_replace('-','', $date);
        
        # 初始化对账单下载对象类
        $bill = new AdapayTools;
        # 对账单下载
        $bill->download(strval($date));
        
        //Log::add('billDownloadUrl', $date);

        // 检查 $bill->result 是否为数组
        if (is_array($bill->result)) {
            $responseData = $bill->result;
        } else {
            $responseData = json_decode($bill->result, true);
        }
        
        // 解码第二个元素（是一个JSON字符串）
        $resultData = json_decode($responseData[1], true);
        
        // 提取data字段，并解码其中的JSON字符串
        $data = json_decode($resultData['data'], true);

        // 初始化变量
        $billDownloadUrl = '';
    
        // 检查响应数据是否存在且第一个元素是否为 200
        if (isset($responseData[0]) && $responseData[0] == 200) {
            
            // 获取bill_download_url的值
            $billDownloadUrl = $data['bill_download_url'];
        }else{
            // 获取error_msg的值
            $errorMsg = $data['error_msg'];
            return  Tools::JsonResponse(['url' => ''], "下载失败,请查看日志:".$errorMsg, 501);

        }

        if($billDownloadUrl == ''){
            Log::add('billDownloadUrl', $responseData);
            return  Tools::JsonResponse(['url' => $billDownloadUrl], "下载失败,请查看日志", 501);
        }

        return  Tools::JsonResponse(['url' => $billDownloadUrl]);
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Category(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->column('parent_id');
            $grid->column('title');
            $grid->column('icon');
            $grid->column('order');
            $grid->column('show');
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');
            });

            // 隐藏列表操作按钮
            $grid->disableActions();

            // 隐藏列表顶部的按钮
            $grid->disableCreateButton();
            $grid->disableBatchDelete();
            $grid->disableExport();
            $grid->disableFilterButton();
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Category(), function (Show $show) {
            $show->field('id');
            $show->field('parent_id');
            $show->field('title');
            $show->field('icon');
            $show->field('order');
            $show->field('show');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Category(), function (Form $form) {
            $form->display('id');
            $form->select('parent_id')
                ->options(Category::selectOptions())
                ->saving(function ($v) {
                    return $v ?? 0;
                });
            $form->text('title');
            // $form->image('icon', '分类图标')
            //     ->accept('jpg,jpeg,png')
            //     ->maxSize(4096)
            //     ->url('upload/category')
            //     ->help('仅支持jpg、jpeg、png格式图片上传（750px * 420px）')
            //     ->autoUpload();
            $form->text('order')->help('越小越靠前');
            $form->switch('show', '状态')->default(1);

            // $form->display('created_at');
            // $form->display('updated_at');

            // 隐藏表单底部的按钮
            $form->disableResetButton();
            $form->disableViewCheck();
            $form->disableEditingCheck();
            $form->disableCreatingCheck();

            // 如果你想隐藏提交按钮，可以使用以下代码
            // $form->disableSubmit();
        });
    }
}
