<?php

namespace App\Admin\Controllers;

use App\Models\City;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Http\Request;

class CityController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new City(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new City(), function (Show $show) {
            $show->field('id');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new City(), function (Form $form) {
            $form->display('id');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }

    public function getList(Request $request)
    {
        $provinceId = $request->get('q');

        return City::where('parent_id', $provinceId)->get(['city_id as id', 'name as text']);
    }
}
