<?php

namespace App\Traits;

trait DatepickerTrait
{

    protected $id = '';

    /**
     * 引入
     * @param $formID
     * @return $this
     */
    public function datepicker($formID)
    {
        $this->id = $formID;

        $this->file();
        $this->script();
        return $this;
    }

    /**
     * 所需要的css js
     */
    protected function file()
    {
        admin_css('/vendor/dcat-admin/dcat/plugins/bootstrap-datetimepicker/bootstrap-datetimepicker.css');
        admin_js('/vendor/dcat-admin/dcat/plugins/moment/moment-with-locales.min.js');
        admin_js('/vendor/dcat-admin/dcat/plugins/bootstrap-datetimepicker/bootstrap-datetimepicker.min.js');
    }

    /**
     * 绑定时间选择器点击事件
     */
    protected function script()
    {
        admin_script(<<<JS
    Dcat.init('#{$this->id} .datepicker .field_started', function (self, id) { var options = {"format":"YYYY-MM-DD","locale":"zh_CN"};
    var last = $('#{$this->id} .datepicker .field_ended');

    self.datetimepicker(options);
    last.datetimepicker($.extend(options, {useCurrent: false}));
    self.on("dp.change", function (e) {
    last.data("DateTimePicker").minDate(e.date);
    $("#{$this->id} .datepicker .btn-primary").data('started', $(this).val())
    });
    last.on("dp.change", function (e) {
    self.data("DateTimePicker").maxDate(e.date);
    $("#{$this->id} .datepicker .btn-primary").data('ended', $(this).val())
    });
    });
    JS);
    }
}
