<?php

namespace App\Store\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $primaryKey = 'slug';
    public $incrementing = false;
    protected $fillable = ['slug', 'value'];

    /**
     * {@inheritDoc}
     */
    public function __construct(array $attributes = [])
    {
        $this->init();

        parent::__construct($attributes);
    }

    protected function init()
    {
        $connection = config('store.database.connection') ?: config('database.default');

        $this->setConnection($connection);

        $this->setTable(config('store.database.settings_table') ?: 'admin_settings');
    }
}
