<?php

namespace App\Store\Models;

use Illuminate\Database\Eloquent\Model;

class Extension extends Model
{
    protected $fillable = ['name', 'is_enabled', 'version', 'options'];

    protected $casts = [
        'options' => 'json',
    ];

    /**
     * {@inheritDoc}
     */
    public function __construct(array $attributes = [])
    {
        $this->init();

        parent::__construct($attributes);
    }

    protected function init()
    {
        $connection = config('store.database.connection') ?: config('database.default');

        $this->setConnection($connection);

        $this->setTable(config('store.database.extensions_table') ?: 'admin_extensions');
    }
}
