<?php



namespace App\Store\Metrics\Examples;



use App\Models\StoreOrder;
use Dcat\Admin\Admin;

use Dcat\Admin\Widgets\Metrics\Bar;

use Illuminate\Http\Request;



class Sessions extends Bar

{

    /**

     * 初始化卡片内容

     */

    protected function init()

    {

        parent::init();



        $color = Admin::color();



        $dark35 = $color->dark35();

        $light = $color->light();



        // 卡片内容宽度

        $this->contentWidth(5, 7);

        // 标题

        $this->title('Avg Sessions');

        // 设置下拉选项

        $this->dropdown([

            '7' => 'Last 7 Days',

            '30' => 'Last Month',

            '365' => 'Last Year',

        ]);

        // 设置图表颜色

        $this->chartColors([
            $color->primary(),

            //$dark35,

            $dark35,

            $dark35,

            $dark35,

            $dark35,

            $dark35

        ]);
    }



    /**

     * 处理请求

     *

     * @param Request $request

     *

     * @return mixed|void

     */

    public function handle(Request $request)

    {

        switch ($request->get('option')) {
            case '30':
                $data = StoreOrder::getNumDaySale(30);
                $this->withContent($data['total'], $data['balance']);
                // 图表数据

                $this->withChart([
                    [
                        'name' => '收益',
                        'data' => array_values($data['list']),
                    ],

                ]);
                break;
            case '7':

            default:

                // 卡片内容
                $data = StoreOrder::getNumDaySale(30);
                $this->withContent($data['total'], $data['balance']);
                // 图表数据

                $this->withChart([
                    [
                        'name' => '收益',
                        'data' => array_values([51, 15, 63, 88, 16, 77, 51]),
                    ],

                ]);
        }
    }



    /**

     * 设置图表数据.

     *

     * @param array $data

     *

     * @return $this

     */

    public function withChart(array $data)

    {

        return $this->chart([

            'series' => $data,

        ]);
    }



    /**

     * 设置卡片内容.

     *

     * @param string $title

     * @param string $value

     * @param string $style

     *

     * @return $this

     */

    public function withContent($title, $value, $style = 'success')

    {

        // 根据选项显示

        $label = strtolower(

            $this->dropdown[request()->option] ?? 'last 7 days'

        );



        $minHeight = '183px';



        return $this->content(

            <<<HTML

<div class="d-flex p-1 flex-column justify-content-between" style="padding-top: 0;width: 100%;height: 100%;min-height: {$minHeight}">

    <div class="text-left">

        <h1 class="font-lg-2 mt-2 mb-0">{$title}</h1>

        <h5 class="font-medium-2" style="margin-top: 10px;">

            <span class="text-{$style}">{$value} </span>

            <span>vs {$label}</span>

        </h5>

    </div>



    <a href="#" class="btn btn-primary shadow waves-effect waves-light">View Details <i class="feather icon-chevrons-right"></i></a>

</div>

HTML

        );
    }
}
