<?php

namespace App\Store\Forms;

use App\Jobs\AutoCompleteOrder;
use App\Models\StoreOrder;
use App\Models\TotalOrder;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;


class SendOutGoods extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {
        $model = StoreOrder::find($this->payload['id']);
        if($input['logistics']=='' || $input['logistics_code']=='' ){
            return $this->response()->error('确认发货失败')->refresh();
        }
        $model->logistics = $input['logistics'] ??'';
        $model->logistics_code = $input['logistics_code'] ??'';
        $model->status = 1;
        if (!$model->save()) {
            return $this->response()->error('确认发货失败')->refresh();
        }
        $order = TotalOrder::find($model->order_id);
        //开启自动完成订单
        dispatch(new AutoCompleteOrder($order,(7*24*3600)));
        return $this->response()->success('确认发货成功')->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {
       $this->text('logistics','物流名称')->required();
       $this->text('logistics_code','物流单号')->required();
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        // 获取外部传递参数
        return [];
    }
}
