<?php
namespace App\Store\Controllers;

use Dcat\Admin\Traits\HasUploadedFile;
use Intervention\Image\Facades\Image;

class UploadFileController{
    use HasUploadedFile;


    public function storeUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('jpg', 90);

        $dir     = '/store';
        $newName = md5(uniqid()) . '.jpg';

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }

    public function storeInvoiceUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('jpg', 90);

        $dir     = '/storeInvoice';
        $newName = md5(uniqid()) . '.jpg';

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }


}
