<?php

namespace App\Store\Controllers;

use App\Models\Income;
use App\Store\Actions\Grid\IncomeApply;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Card;

class StoreIncomeController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Income(), function (Grid $grid) {
            //$grid->tools(new IncomeApply());
            $grid->addTableClass(['table-text-center']);
            $merchant_id = Admin::user()->merchant_id;
            $grid->model()->where(['user_type' => 2, 'um_id' => $merchant_id])->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('amount', '金额');
            $grid->column('status')->using(Income::STATUS)->dot([
                0 => 'primary',
                1 => 'success',
                2 => 'danger'
            ]);
            $grid->column('created_at', '提现时间');

            $grid->disableDeleteButton();
            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableBatchActions();
            $grid->disableActions();
            $grid->disableRowSelector();
            // $grid->selector(function (Grid\Tools\Selector $selector) {
            //     $selector->selectOne('status', '状态', Income::STATUS);
            // });
            // $grid->filter(function (Grid\Filter $filter) {
            //     $filter->equal('id');
            // });
        });
    }
}
