<?php

namespace App\Store\Controllers;

use App\Models\UserAddress;
use App\Models\UserRefund;
use App\Store\Actions\Grid\RefundToExamine;
use App\Store\Actions\Grid\SendOutGoods;
use App\Models\StoreOrder;
use App\Models\OrderInfo;
use App\Models\City;
use App\Models\Store;
use App\Models\User;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Card;
use App\Admin\Renderable\OrderGoodsList;

class OrderInfoController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new OrderInfo(), function (Grid $grid) {
            $grid->addTableClass(['table-text-center']);
            $merchant_id = Admin::user()->merchant_id;
            $grid->model()->where(['merchant_id' => $merchant_id])->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('order_sn', '订单号');
            $grid->column('mobile', '手机号');
            $grid->column('goods', '商品信息')->expand(function (Grid\Displayers\Expand $expand) {
                $expand->button('查看');
                return OrderGoodsList::make(['order_id' => $this->id]);
            })->width(100);
            $grid->column('goods_amount', '订单总金额');
            $grid->column('merchant.name', '所属商家');
            $grid->column('merchant.province_id', '所在省市')->display(function ($val) {
                $proObj = City::where("city_id", $val)->first();
                $cityObj = City::where("city_id", $this->merchant->city_id)->first();
                $proname = $proObj->name ?? '';
                $cityname = $cityObj->name ?? '';
                return $proname . " " . $cityname;
            });
            $grid->column('store_id', '快递代收点')->display(function ($val) {
                $res = null;
                if ($val) {
                    $obj = Store::where('id', $val)->first();
                    $res = $obj->address;
                }
                return $res;
            });
            $grid->column('address_id', '送货上门')->display(function ($val) {
                $res = '';
                if ($val) {
                    $obj = UserAddress::where('id', $val)->first();
                    $res = $obj->area;
                }
                return $res;
            });
            $grid->column('created_at', '下单时间');
            $grid->column('order_status', '订单状态')->display(function ($val) {
                $options = OrderInfo::STATUS_OPTIONS;
                return $options[$val];
            });
            $grid->column('verifier', '核销员');
            $grid->column('verification_at', '核销时间');

            $grid->simplePaginate();
            $grid->disableActions();
            $grid->disableCreateButton();
            $grid->disableBatchActions();
            // $grid->simplePaginate();
            // $grid->disableFilterButton();
            // $grid->quickSearch('store_goods.title')->placeholder('搜索商品');
            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->equal('order_sn', '订单号')->width(3);
                $filter->like('phone', '手机号')->width(3);
                $filter->between('created_at', '创建时间')->datetime()->width(4);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new StoreOrder(), function (Show $show) {
            $show->field('id');
            $show->field('order_id');
            $show->field('goods_id');
            $show->field('num');
            $show->field('address_id');
            $show->field('status');
            $show->field('over_time');
            $show->field('voucher');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new StoreOrder(), function (Form $form) {
            $form->display('id');
            $form->text('order_id');
            $form->text('goods_id');
            $form->text('num');
            $form->text('address_id');
            $form->text('status');
            $form->text('over_time');
            $form->text('voucher');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
