<?php

namespace App\Store\Controllers;

use App\Models\Merchant;
use App\Models\OrderDivideRecord;
use App\Store\Actions\Grid\IncomeApply;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Card;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Widgets\Box;

class OrderDivideRecordController extends AdminController
{

    // public function index(Content $content)
    // {
    //     return $content->header('自定义表单')->body($this->grid());
    // }
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new OrderDivideRecord(), function (Grid $grid) {
            $merchant_id = Admin::user()->merchant_id;
            $total_revenue = $balance = $cashout = 0;
            if ($merchant_id) {
                $merObj = Merchant::where('id', $merchant_id)->first();
                $total_revenue = $merObj->total_revenue ?? 0;
                $balance = $merObj->balance ?? 0;
                $cashout = $total_revenue - $balance;
            }
            $grid->header(function () use ($total_revenue, $balance, $cashout) {
                $box = new Box('统计信息', '这里可以放置统计数据');

                // 自定义统计框样式
                $box->style('info'); // 可选的样式：primary, info, warning, danger, success, default
                $content = '<div style="height: 135px;display: flex;align-items: center;text-align: center;">
                    <div style="flex: 1;display: flex;flex-direction: column;border-right: 1px solid #b9c3cd;">
                    <h2 style="font-size: 25px;margin-top: 25px;">总金额(元)</h2>
                    <p style="color: orange;font-size: 45px;font-weight: bold;">' . $total_revenue . '</p>
                    </div>
                    <div style="flex: 1;display: flex;flex-direction: column;border-right: 1px solid #b9c3cd;">
                    <h2 style="font-size: 25px;margin-top: 25px;">已提现金额(元)</h2><p style="color:#21b978;font-size: 45px;font-weight: bold;">' . $cashout . '</p>
                    </div>
                    <div style="flex: 1;display: flex;flex-direction: column;">
                    <h2 style="font-size: 25px;margin-top: 25px;">总余额(元)</h2><p style="color: red;font-size: 45px;font-weight: bold;">' . $balance . '</p>
                    </div></div>';
                // 添加统计数据
                $box->content(
                    $content
                );

                return $box->render();
            });
            $grid->addTableClass(['table-text-center']);

            $grid->model()->where(['sh_type' => 3, 'um_id' => $merchant_id])->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('title', '来源名称')->display(function ($val) {
                return $val ?? '用户取货佣金';
            });
            $grid->column('divide_price', '金额');
            $grid->column('created_at', '时间');

            $grid->disableDeleteButton();
            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableBatchActions();
            $grid->disableRefreshButton();
            $grid->disableActions();
            $grid->disableRowSelector();
            // $grid->filter(function (Grid\Filter $filter) {
            //     $filter->equal('id');
            // });
        });
    }
}
