<?php

namespace App\Store\Controllers;

use App\Models\MerchantStore;
use App\Models\MerchantGoodSku;
use App\Admin\Renderable\MerchantStoreSkuList;
use App\Models\Good;
use App\Models\StoreGoodsCategory;
use App\Models\StoreGoodsTag;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class MerchatGoodsStoreController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(MerchantStore::with(['goods', 'merchant']), function (Grid $grid) {
            $grid->addTableClass(['table-text-center']);
            $merchant_id = Admin::user()->merchant_id;
            $grid->model()->where(['merchant_id' => $merchant_id])->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('goods_sn', '商品编号');
            $grid->column('goods.cover_img', '商品图片')->image(env('IMAGE_URL'), 100, 100);
            $grid->column('goods.goods_name', '商品名称');
            $grid->column('attr', '商品规格')->expand(function (Grid\Displayers\Expand $expand) {
                $expand->button('查看');
                return MerchantStoreSkuList::make(['mgs_id' => $this->id]);
            })->width(100);
            $grid->column('store', '库存')->display(function ($val) use ($merchant_id) {
                $mgsId = $this->id;
                $gid = $this->goods_id;
                $stock = MerchantGoodSku::where(['mgs_id' => $mgsId, 'merchant_id' => $merchant_id, 'goods_id' => $gid])->sum('stock');
                return $stock;
            });

            $grid->setDialogFormDimensions('70%', '90%');
            $grid->enableDialogCreate();
            $grid->showQuickEditButton();
            $grid->disableCreateButton();
            $grid->disableEditButton();
            $grid->disableViewButton();
            $grid->disableActions();
            $grid->disableRowSelector();
            // $grid->simplePaginate();
            $grid->disableFilterButton();
            $grid->quickSearch('goods.goods_name')->placeholder('搜索商品');
            // $grid->filter(function (Grid\Filter $filter) {
            //     $filter->equal('id');
            // });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id) {}

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form() {}
}
