<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use App\Models\Merchant;
use App\Models\Store;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class StoreAdminUsers extends Authenticatable
{
    use HasDateTimeFormatter;
    use HasApiTokens, HasFactory, Notifiable;
    protected $table = 'store_admin_users';

    public function verifier()
    {
        //return $this->belongsTo(Verifier::class, 'store_admin_users_id');
    }

    public function merchant()
    {
        return $this->belongsTo(Merchant::class, 'merchant_id');
    }

    public function store()
    {
        return $this->belongsTo(Store::class, 'store_id');
    }
}
