<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class OrderInfo extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'li_order_info';

    public const STATUS_OPTIONS = [
        0 => '待付款',
        1 => '待到货',
        2 => '待领取',
        3 => '待评价',
        4 => '已完成',
        7 => '已取消',
        //8 => '已退款',
    ];


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function merchant()
    {
        return $this->belongsTo(Merchant::class, 'merchant_id');
    }

    /**
     * 获取日期订单量
     * started 开始时间
     * ended 截至时间
     * status 订单状态
     * merchant_id 商户ID
     */
    public static function getNumData($started = '', $ended = '', $status = [], $merchant_id = 0)
    {
        $where = ['pay_status' => 1];
        $sqlObj = new self();
        if ($merchant_id) {
            $where['merchant_id'] = $merchant_id;
        }
        if ($status) {
            $sqlObj = $sqlObj->whereIn('order_status', $status);
        }
        if ($started && $ended) {
            $startTime = $started . ' 00:00:00';
            $endTime = $ended . ' 23:59:59';
            $sqlObj = $sqlObj->whereBetween('created_at', [$startTime, $endTime]);
        }
        $count = $sqlObj->where($where)->count();

        return $count;
    }
    //指定天数
    public static function getNumDayData($dayNum, $status = [])
    {
        $days = [date('Y-m-d')];
        for ($i = 1; $i < $dayNum; $i++) {
            $days[] = date("Y-m-d", strtotime("-$i day"));
        }
        $days = array_reverse($days);
        $data = [
            'total' => 0,
            'list' => []
        ];
        //DB::enableQueryLog();
        $sqlObj = new self();
        foreach ($days as $day) {
            $startTime = $day . ' 00:00:00';
            $endTime = $day . ' 23:59:59';
            $count = $sqlObj->whereIn('order_status', $status)->whereBetween('created_at', [$startTime, $endTime])->count();
            //$queries = DB::getQueryLog();
            $data['list'][$day] = $count;
            $data['total'] += $count;
        }

        return $data;
    }

    //统计获取默天的销售额
    public static function getDayAmount($dayDate)
    {
        $startTime = $dayDate . ' 00:00:00';
        $endTime = $dayDate . ' 23:59:59';
        $sqlObj = new self();
        $amount = $sqlObj->whereBetween('created_at', [$startTime, $endTime])
            ->where('pay_status', 1)
            ->whereNull('deleted_at')->sum('order_amount');
        return $amount;
    }


    //统计获取月销售额 2023-09
    public static function getMonthAmount($monthDate)
    {
        $mdate = $monthDate . "-01";

        $firstDayOfMonth = date('Y-m-01', strtotime(date($mdate)));
        $lastDayOfMonth  = date('Y-m-t', strtotime(date($mdate)));

        $startTime = $firstDayOfMonth . ' 00:00:00';
        $endTime = $lastDayOfMonth . ' 23:59:59';
        $sqlObj = new self();
        $amount = $sqlObj->whereBetween('created_at', [$startTime, $endTime])
            ->where('pay_status', 1)
            ->whereNull('deleted_at')->sum('order_amount');
        return $amount;
    }

    //获取最近一年的订单量
    public static function getYearData()
    {
        $y = date('Y');
        $m = date('m');

        for ($i = 1; $i <= $m; $i++) {
            $days[] = $y . '-' . $i;
        }
        $data = [
            'total' => 0,
            'list' => []
        ];
        $where = [];
        foreach ($days as $day) {
            $startTime = $day . '-01 00:00:00';
            $m_max_day = date('t', strtotime($startTime));
            $endTime = $day . '-' . $m_max_day . ' 23:59:59';
            $count = self::whereBetween('created_at', [$startTime, $endTime])->where($where)->count();
            $data['list'][$day] = $count;
            $data['total'] += $count;
        }
        return $data;
    }

    public static function CreateImportData($item): array
    {
        // [0] => 北海道香格里拉
        // [1] => 江户川区
        // [2] => 新左近川亲水公园
        // [3] => 3室2厅2卫
        // [4] => 21-100
        // [5] => 121.23917
        // [6] => 31.19145
        // [7] => 精装修|有车位
        // [8] => 8000-20000
        // [9] => Array
        // (
        //     [0] => /housing/20240305/d3f238df7cfe166d878b141e9562e1d0.png
        // )
        // [10] => 交通配套周边直
        $result = $item;
        // echo "<pre>";
        // print_r($result);
        // die;
        $tags = $result[7];
        if ($tags) {
            $tagsArr = explode("|", $tags);
            $tmp = [];
            foreach ($tagsArr as $key => $val) {
                //去除无标签
                $exist = DB::table('tag')->where("title", $val)->first();
                if ($exist) {
                    array_push($tmp, $val);
                }
            }
            $tags = json_encode($tmp, JSON_UNESCAPED_UNICODE);
        }
        $imgs = '';
        if ($item[9]) {
            $imgs = json_encode($item[9], JSON_UNESCAPED_UNICODE);
        }
        $name = $result[0];
        if ($result[0]) {
            $exist = self::where("name", $result[0])->first();
            $name = !$exist ? $name : '';
        }

        $data = [
            'name' => $name,
            //'area_id' => AreaModel::getIdByName($result[1]),
            'position' => $result[2],
            'layout_house' => $result[3],
            'extent' => $result[4],
            'lng' => $result[5],
            'lat' => $result[6],
            'tags' => $tags,
            'rent' => $result[8],
            'imgs' => $imgs,
            'describe' => $result[10],
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        return $data;
    }
}
