<?php

namespace App\Models;

use App\Command\Log;
use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class OrderDivideRecord extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;
    protected $table = 'order_divide_record';

    public const COMMISSION_TYPE = [
        1 => '直推佣金',
        2 => '间推佣金',
        3 => '用户取货佣金',
    ];


    //收益分配
    public static function divide($order_id)
    {
        $orderObj = OrderInfo::find($order_id);
        $merchant_id = $orderObj->merchant_id; //绑定的商户
        $user_id = $orderObj->user_id; //下单用户ID
        $userObj = User::find($user_id);
        $spuid = $userObj->spuid; //直推分享人
        $second_spuid = $userObj->second_spuid; //间推分享人
        $ogList = OrderGoods::where("order_id", $order_id)->get(); //订单商品
        foreach ($ogList as $kk => $item) {
            $goods_amount = $item->goods_price * $item->goods_number;
            //商品信息
            $goodObj = Good::find($item->goods_id);
            $merchant_commission = $goodObj->merchant_commission;
            $first_commission = $goodObj->first_commission;
            $second_commission = $goodObj->second_commission;
            //直推佣金
            if ($spuid && $first_commission >= 1 && $first_commission < 100) {
                $divide_price = number_format($goods_amount * ($first_commission / 100), 2);
                //收益直接到直推账户
                $spObj = User::find($spuid);
                $spObj->total_revenue += $divide_price;
                $spObj->balance += $divide_price;
                $spObj->save();
                self::addRecord($item->id, $order_id, $goods_amount, $divide_price, $first_commission, $spuid, $user_id, 1);
            }
            //间推佣金
            if ($second_spuid && $second_commission >= 1 && $second_commission < 100) {
                $divide_price = number_format($goods_amount * ($second_commission / 100), 2);
                //收益直接到直推账户
                $spObj = User::find($second_spuid);
                $spObj->total_revenue += $divide_price;
                $spObj->balance += $divide_price;
                $spObj->save();
                self::addRecord($item->id, $order_id, $goods_amount, $divide_price, $second_commission, $second_spuid, $user_id, 2);
            }
            //商户分佣记录
            if ($merchant_id && $merchant_commission >= 1 && $merchant_commission < 100) {
                $divide_price = number_format($goods_amount * ($merchant_commission / 100), 2);
                //收益直接到商户账户
                $merObj = Merchant::find($merchant_id);
                $merObj->total_revenue += $divide_price;
                $merObj->balance += $divide_price;
                $merObj->save();
                //记录
                self::addRecord($item->id, $order_id, $goods_amount, $divide_price, $merchant_commission, $merchant_id, $user_id, 3);
            }
        }
    }

    public static function addRecord($og_id, $order_id, $goods_amount, $divide_price, $commission, $um_id, $user_id, $sh_type)
    {
        $recordObj = new self();
        $recordObj->order_id = $order_id;
        $recordObj->user_id = $user_id; //下单userId
        $recordObj->og_id = $og_id;
        $recordObj->order_price = $goods_amount;
        $recordObj->divide_price = $divide_price;
        $recordObj->proportion = $commission;
        $recordObj->um_id = $um_id;
        $recordObj->sh_type = $sh_type;
        $recordObj->save();
        Log::add('订单分佣记录', $recordObj->toArray());
    }
}
