<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use App\Models\Store;
use App\Models\Merchant;
use App\Models\Good;

class MerchantGoodsStore extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;
    protected $table = 'merchat_goods_store';

    public function store_desc()
    {
        return $this->hasMany(Store::class, 'merchant_id');
    }

    public function goods()
    {
        return $this->belongsTo(Good::class, 'goods_id');
    }

    public function merchant()
    {
        return $this->belongsTo(Merchant::class, 'merchant_id');
    }
}
