<?php

namespace App\Models;

use App\Command\Log;
use Dcat\Admin\Traits\HasDateTimeFormatter;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Good extends Model
{
    use HasDateTimeFormatter;
    protected $table = 'li_goods';

    public static function getTableName()
    {
        return with(new static)->getTable();
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'cat_id');
    }

    public function gattr()
    {
        return $this->hasMany(GoodSku::class);
    }

    public static function CreateImportData($item): array
    {
        // [0] => 尼克诺拉鸡尾酒杯马天尼高脚古典酒杯日式调酒杯香槟
        // [1] => 田园
        // [2] => CT2701CRISON
        // [3] => 红酒
        // [4] => 12
        // [5] => 京东自营
        // [6] => jd.com
        // [7] => Array
        //    (
        //     [0] => /goods/20240712/abc7927e8097e25fdae1553c2f582eac.png
        //    )
        // [8] => Array
        //     (
        //        [0] => /goods/20240712/b9ae9264d848e8cfcaf9edf62b649b34.png
        //     )
        // [9] => 张强
        // [10] => 13856780987
        // [11] => 颜色:白色、尺寸:22寸
        // 颜色:蓝色、尺寸:22寸
        // [12] => 0-199、200-500
        // 0-199、200-500
        // [13] => 800、780
        // 860、790
        // [14] => 880
        // [15] => 900
        // [16] => 920
        // [17] => 1000

        $result = $item;
        $goods_name = $item[0];
        $cat_id = Category::getIdByName($result[1]);
        $product_no = $item[2];
        $material = $item[3];
        $box_size = $item[4];
        $is_jd = ($item[5] == '京东自营') ? 1 : 0;
        $jd_url = $item[6];
        $cover_img = $item[7] ? $item[7][0] : null;
        $carousel = $item[8] ? json_encode($item[8], JSON_UNESCAPED_UNICODE) : null;
        $supplier = $item[9];
        $su_phone = $item[10];
        //规格处理
        $attr_val = isset($item[11]) ? $item[11] : ''; //规格
        $attrArr = $attr_val ? explode("\n", $attr_val) : [];
        Log::add("规格", $attrArr);
        $numb = isset($item[12]) ? $item[12] : ''; //数量
        $numArr = $numb ? explode("\n", $numb) : [];
        $price = isset($item[13]) ? $item[13] : ''; //折扣价
        $priceArr = $price ? explode("\n", $price) : [];
        $cg_price = isset($item[14]) ? $item[14] : 0; //采购价
        $jd_price = isset($item[15]) ? $item[15] : 0; //京东价
        $market_price = isset($item[16]) ? $item[16] : 0; //市场价
        $stock = isset($item[16]) ? $item[16] : 0; //库存
        $sku = null;
        if ($attrArr) {
            // 这里是给sku填数据， 数据格式为
            $result = $attrs = [];
            foreach ($attrArr as $key => $val) {
                $rows = explode("、", $val);
                foreach ($rows as $kk => $vv) {
                    $item = explode(":", $vv);
                    $itkey = trim($item[0]);
                    if (!isset($attrs[$itkey])) {
                        $attrs[$itkey][] = $item[1];
                    } else {
                        if (!in_array($item[1], $attrs[$itkey])) {
                            $attrs[$itkey][] = $item[1];
                        }
                    }
                }
            }
            $result['attrs'] = $attrs;
            //规格值
            $skuArr = [];
            foreach ($attrArr as $kk => $vv) {
                $tmp = [
                    "numb" => isset($numArr[$kk]) ? $numArr[$kk] : '',
                    "price" => isset($priceArr[$kk]) ? $priceArr[$kk] : '',
                    "cg_price" => $cg_price,
                    "jd_price" => $jd_price,
                    "market_price" => $market_price,
                    "stock" => $stock
                ];
                //$vv == 颜色:白色、尺寸:22寸
                $ggarr = explode("、", $vv);
                foreach ($ggarr as $gg) {
                    $arr = explode(":", $gg);
                    if ($arr[0]) {
                        $tmp[$arr[0]] = $arr[1];
                    }
                }

                array_push($skuArr, $tmp);
            }
            $result['sku'] = $skuArr;
            $sku =  json_encode($result, JSON_UNESCAPED_UNICODE);
        }

        $data = [
            'goods_name' => $goods_name,
            'cat_id' => $cat_id,
            'product_no' => $product_no,
            'material' => $material,
            'box_size' => $box_size,
            'is_jd' => $is_jd,
            'jd_url' => $jd_url,
            'supplier' => $supplier,
            'su_phone' => $su_phone,
            'cover_img' => $cover_img,
            'carousel' => $carousel,
            'sku' => $sku,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        return $data;
    }

    //获取指定天数订单量
    public static function getNumDayData($dayNum)
    {
        $days = [date('Y-m-d')];
        for ($i = 1; $i < $dayNum; $i++) {
            $days[] = date("Y-m-d", strtotime("-$i day"));
        }
        $days = array_reverse($days);
        $data = [
            'total' => 0,
            'list' => []
        ];
        $where = [];
        foreach ($days as $day) {
            $startTime = $day . ' 00:00:00';
            $endTime = $day . ' 23:59:59';
            $count = self::whereBetween('created_at', [$startTime, $endTime])->where($where)->count();
            $data['list'][$day] = $count;
            $data['total'] += $count;
        }
        return $data;
    }


    //获取最近一年的订单量
    public static function getYearData()
    {
        $y = date('Y');
        $m = date('m');

        for ($i = 1; $i <= $m; $i++) {
            $days[] = $y . '-' . $i;
        }
        $data = [
            'total' => 0,
            'list' => []
        ];
        $where = [];
        foreach ($days as $day) {
            $startTime = $day . '-01 00:00:00';
            $m_max_day = date('t', strtotime($startTime));
            $endTime = $day . '-' . $m_max_day . ' 23:59:59';
            $count = self::whereBetween('created_at', [$startTime, $endTime])->where($where)->count();
            $data['list'][$day] = $count;
            $data['total'] += $count;
        }
        return $data;
    }
}
