<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Advantage extends Model
{
	use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'advantage';

    protected $fillable  = [
        'cate_1','cate_2','cate_3','cate_4','characteristic	','brand_level','brand_id','company','goods','contacts'
    ];

    public static function getTableName()
    {
        return with(new static)->getTable();
    }

    public function brand(){
        return  $this->belongsTo(Brand::class,'brand_id','id');
    }

    public function brand_level_model(){
        return  $this->belongsTo(BrandLevel::class,'brand_level','id');
    }

    public static function CreateImportData($item): array
    {

        $cate_1_id = Category::getIdForNameAndParentId(trim($item[1]),0);
        $cate_2_id = Category::getIdForNameAndParentId(trim($item[2]),$cate_1_id);
        $cate_3_id = Category::getIdForNameAndParentId(trim($item[3]),$cate_2_id);
        $cate_4_id = Category::getIdForNameAndParentId(trim($item[4]),$cate_3_id);
        $brand_level = BrandLevel::firstOrCreate(['title'=>trim($item[6])])->id;
        $brand_id = Brand::firstOrCreate(['title'=>trim($item[7])])->id;
        return [
            'cate_1'=>$cate_1_id,
            'cate_2'=>$cate_2_id,
            'cate_3'=>$cate_3_id,
            'cate_4'=>$cate_4_id,
            'characteristic'=>trim($item[5]),
            'brand_level'=>$brand_level,
            'brand_id'=>$brand_id,
            'company'=>trim($item[8]),
            'goods'=>trim($item[9]),
            'contacts'=>trim($item[10]),
            'created_at'=>date('Y-m-d H:i:s'),
            'updated_at'=>date('Y-m-d H:i:s'),
        ];
    }

}
