<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\SystemSetting as SystemSettingModel;
use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelLow;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Label\Label;
use Endroid\QrCode\Logo\Logo;
use Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeMargin;
use Endroid\QrCode\Writer\PngWriter;

class SystemSettingController extends BaseController
{


    public function verificationGrCode(Request $request)
    {
        $user_id = $request->user()->id;
        $code = $request->code;
        $writer = new PngWriter();

        //$str = "#小程序://留日指南/AYpQ1H8PIFNvUaC";
        $qrCode = QrCode::create($code)
            ->setEncoding(new Encoding('UTF-8'))
            ->setErrorCorrectionLevel(new ErrorCorrectionLevelLow())
            ->setSize(300)
            ->setMargin(10)
            ->setRoundBlockSizeMode(new RoundBlockSizeModeMargin())
            ->setForegroundColor(new Color(0, 0, 0))
            ->setBackgroundColor(new Color(255, 255, 255));
        $result = $writer->write($qrCode);
        $dataUri = $result->getDataUri();

        // 指定保存路径
        $folder_name = "/qrcode/" . date("Ymd", time());
        $filename = md5("verifi_code_" . $code . "_" . $user_id) . ".png";
        $savePath = public_path() . "/uploads" . $folder_name . "/";
        if (!file_exists($savePath)) {
            mkdir($savePath, 0755, true);
        }
        $result->saveToFile($savePath . $filename);
        $filepath = env('IMAGE_URL') . $folder_name . "/" . $filename;
        //$qrCode->writeFile($savePath);
        return $this->JsonResponse(['qrcode' => $dataUri, 'filepath' => $filepath]);
        // 返回二维码图片的Base64编码
        //return response()->json(['status' => 'success', 'qrcode' => 'data:image/png;base64,' . base64_encode($qrCode)]);
    }

    public function qrCode(Request $request)
    {
        $user_id = $request->user()->id;
        $writer = new PngWriter();

        $spurl = env("API_URL") . "/share?code=" . $user_id;

        $qrCode = QrCode::create($spurl)
            ->setEncoding(new Encoding('UTF-8'))
            ->setErrorCorrectionLevel(new ErrorCorrectionLevelLow())
            ->setSize(300)
            ->setMargin(10)
            ->setRoundBlockSizeMode(new RoundBlockSizeModeMargin())
            ->setForegroundColor(new Color(0, 0, 0))
            ->setBackgroundColor(new Color(255, 255, 255));
        $result = $writer->write($qrCode);
        $dataUri = $result->getDataUri();

        // 指定保存路径
        $folder_name = "/qrcode/" . date("Ymd", time());
        $filename = "qrcode_" . $user_id . ".png";
        $savePath = public_path() . "/uploads" . $folder_name . "/";
        if (!file_exists($savePath)) {
            mkdir($savePath, 0755, true);
        }
        $result->saveToFile($savePath . $filename);
        $filepath = env('API_URL') . "/uploads" . $folder_name . "/" . $filename;
        //$qrCode->writeFile($savePath);
        return $this->JsonResponse(['qrcode' => $dataUri, 'filepath' => $filepath]);
        // 返回二维码图片的Base64编码
        //return response()->json(['status' => 'success', 'qrcode' => 'data:image/png;base64,' . base64_encode($qrCode)]);
    }
    //
    public function companyIntro(Request $request)
    {
        $articleObj = SystemSettingModel::find(1);
        if (!$articleObj) {
            return $this->JsonResponse('', '参数错误', 201);
        }

        $cp_brief = $articleObj->cp_brief ?? '';


        return  $this->JsonResponse(['intro' => $cp_brief]);
    }

    public function cashoutIntro(Request $request)
    {
        $articleObj = SystemSettingModel::find(1);
        if (!$articleObj) {
            return $this->JsonResponse('', '参数错误', 201);
        }

        $cashout_brief = $articleObj->cashout_brief ?? '';


        return  $this->JsonResponse(['intro' => $cashout_brief]);
    }

    public function getBj(Request $request)
    {
        $articleObj = SystemSettingModel::find(1);
        if (!$articleObj) {
            return $this->JsonResponse('', '参数错误', 201);
        }

        $bj = ($articleObj->bj_invite ? env('IMAGE_URL') . $articleObj->bj_invite : "");

        return  $this->JsonResponse(['bj' => $bj]);
    }
}
