<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\Store;
use Illuminate\Http\Request;

class StoreController extends BaseController
{
    public function getList()
    {
        $list = (new Store())->select("id", "title", "contact", "is_type")
            ->limit(15)
            ->get();

        return  $this->JsonResponse($list);
    }

    //代收点列表
    public function getDeliveryList(Request $request)
    {
        $mid = $request->user()->merchant_id;
        $lat1 = $request->lat ?? '';
        $lng1 = $request->lng ?? '';
        $list = Store::where(['merchant_id' => $mid])
            ->select(['id', 'title', 'lat_lng', 'address', 'contacts', 'phone'])->get();
        foreach ($list as $key => $val) {
            $atng = $val->lat_lng ? explode(',', $val->lat_lng) : [];
            $lat2 = $atng[1];
            $lng2 = $atng[0];
            $list[$key]['distance'] = ($lat1 && $lat2) ? $this->haversineDistance($lat1, $lng1, $lat2, $lng2) : '';
        }

        return  $this->JsonResponse($list);
    }

    //送货上门-距离判断
    public function checkDistance(Request $request)
    {
        $mid = $request->user()->merchant_id;
        $lat1 = $request->lat ?? '';
        $lng1 = $request->lng ?? '';
        $flag = false;
        $store_id = 0;
        if ($mid) {
            $list = Store::where(['merchant_id' => $mid])
                ->select(['id', 'title', 'lat_lng', 'distance'])->get();
            foreach ($list as $key => $val) {
                $atng = $val->lat_lng ? explode(',', $val->lat_lng) : [];
                $lat2 = $atng[1];
                $lng2 = $atng[0];
                $res = ($lat1 && $lat2) ? $this->haversineDistance($lat1, $lng1, $lat2, $lng2) : '';
                if ($res <= $val->distance) {
                    $flag = true;
                    break;
                }
            }
        } else {
            $flag = true;
        }
        return  $this->JsonResponse(['flag' => $flag, 'delivery_store_id' => $store_id]);
    }

    function haversineDistance($lat1, $lng1, $lat2, $lng2)
    {
        // 地球半径（单位：千米）
        $radius = 6371;

        // 将角度转为弧度
        $lat1 = deg2rad($lat1);
        $lng1 = deg2rad($lng1);
        $lat2 = deg2rad($lat2);
        $lng2 = deg2rad($lng2);

        // 计算经纬度差值
        $latDiff = $lat2 - $lat1;
        $lngDiff = $lng2 - $lng1;

        // 计算Haversine公式中的参数
        $a = pow(sin($latDiff / 2), 2) + cos($lat1) * cos($lat2) * pow(sin($lngDiff / 2), 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $distance = $radius * $c;

        return floor($distance);
    }
}
