<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Handlers\FileUploadHandler;
use App\Models\Merchant;
use App\Models\Store;
use App\Models\StoreAdminUsers;
use App\Models\UserPermission;
use App\Models\PersonalAccessToken;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class StoreAdminUsersController extends BaseController
{
    public function login(Request $request)
    {
        //         $user = User::find(1);
        //         $accessToken = 'Bearer '.$user->createToken('Access-token')->plainTextToken;
        //         return $this->JsonResponse([ 'Authorization'=>$accessToken,]);

        //        $encryptedData = $request->encryptedData ?? '';
        //        $iv = $request->iv ?? '';
        //        $session_key = $request->session_key ?? '';
        //        $openId = $request->openid ??'';
        //        $res = $this->decryptData($session_key,$encryptedData,$iv,$data);
        //        if($res != 0 ){
        //            return $this->JsonResponse('','参数异常',201);
        //        }

        $username = $request->username ?? '';
        $password = $request->password ?? '';

        $user = StoreAdminUsers::where(['username' => $username])->first();

        if (!$user) {
            return $this->JsonResponse('', '用户不存在', 201);
        }

        if (!Hash::check($password, $user->password)) {
            return $this->JsonResponse('', '账号或密码错误', 500);
        }
        //生成token
        $accessToken = 'Bearer ' . $user->createToken('Access-token')->plainTextToken;
        Log::add('商家端用户--' . $user->id . '登录', ['token' => $accessToken]);

        return $this->JsonResponse([
            'Authorization' => $accessToken,
        ]);
    }

    public function logout(Request $request)
    {
        $request->user()->tokens()->delete();
        PersonalAccessToken::where(['tokenable_id' => $request->user()->id])->delete();
        return $this->JsonResponse('');
    }

    public function info(Request $request)
    {
        $muser = $request->user();
        $buycode = '';
        $merchant_id = $muser->merchant_id;
        $store_id = $muser->store_id;
        $total_revenue = $balance = $cashout = 0;
        $store_name = '';
        if ($merchant_id) {
            $merObj = Merchant::where('id', $merchant_id)->first();
            $buycode = $merObj->buycode;
            $phone = $merObj->phone;
            $total_revenue = $merObj->total_revenue ?? 0;
            $balance = $merObj->balance ?? 0;
            $cashout = $total_revenue - $balance;
        }
        if ($store_id) {
            $storeObj = Store::where('id', $store_id)->first();
            $store_name = $storeObj->title;
            $phone = $storeObj->phone;
        }
        return $this->JsonResponse([
            'user_id' => $muser->id,
            'username' => $muser->username,
            'merchant_name' => $muser->name,
            'phone' => $phone,
            'avatar' => $muser->avatar ? env('IMAGE_URL') . $muser->avatar : env('NO_AVATAR_IMAGE_URL'),
            'merchant_id' => $muser->merchant_id,
            'buycode' => $buycode,
            'total_revenue' => $total_revenue,
            'balance' => $balance,
            'cashout' => $cashout,
            'role_id' => $muser->role_id,
            'store_name' => $store_name
        ]);
    }
}
