<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\Carousel;
use App\Models\User;
use App\Models\OrderDivideRecord;
use Illuminate\Http\Request;

class OrderDivideRecordController extends BaseController
{
    public function getList(Request $request)
    {
        $type = $request->type ?? 0;
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;
        if (!in_array($type, [1, 2, 3])) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $sql = OrderDivideRecord::where(['um_id' => $request->user()->id, 'sh_type' => $type, 'deleted_at' => null]);

        $total = $sql->count();
        $data = [
            'total' => $total,
            'total_page' => ceil($total / $limit),
            'list' => []
        ];
        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $kk => $vv) {
                $data['list'][] = [
                    'title' => isset(OrderDivideRecord::COMMISSION_TYPE[$vv->sh_type]) ? OrderDivideRecord::COMMISSION_TYPE[$vv->sh_type] : '',
                    'created_at' => date("Y-m-d H:i:s", strtotime($vv->created_at)),
                    'divide_price' => $vv->divide_price
                ];
            }
        }

        return  $this->JsonResponse($data);
    }
}
