<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\Merchant;
use App\Models\User as UserModel;
use App\Models\OrderDivideRecord;
use Illuminate\Http\Request;

class MerchantController extends BaseController
{
    //绑定直购码用户列表
    public function getUserList(Request $request)
    {
        $mer_id = $request->user()->merchant_id;
        $merObj = Merchant::where('id', $mer_id)->first();
        $buycode = $merObj->buycode ?? '';
        if (!$buycode) {
            return $this->JsonResponse('', '参数错误', 201);
        }
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;

        $sql = UserModel::where(['buycode' => $buycode, 'status' => 1, 'deleted_at' => null]);

        $total = $sql->count();
        $data = [
            'divideAmount' => 0,
            'total' => $total,
            'total_page' => ceil($total / $limit),
            'list' => []
        ];
        //商户佣金总额
        $divideAmount = OrderDivideRecord::where(['sh_type' => 3, 'um_id' => $mer_id])->sum('divide_price');
        $data['divideAmount'] = (float)$divideAmount;

        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                //获取会员给商户产生的佣金
                $uid = $item->id;
                $divide_price = OrderDivideRecord::where(['sh_type' => 3, 'um_id' => $mer_id, 'user_id' => $uid])->sum('divide_price');
                $data['list'][] = [
                    'uid' => $uid,
                    'name' => $item->name,
                    'divide_price' => (float)$divide_price,
                    'avatar' => (isset($item->avatar) ? env('IMAGE_URL') . $item->avatar : env('NO_AVATAR_IMAGE_URL')),
                    'created_at' => date('Y-m-d H:i:s', strtotime($item->created_at)),
                ];
            }
        }

        return  $this->JsonResponse($data);
    }
}
