<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\PersonalAccessToken;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class LoginController extends BaseController
{

    /**
     * 检验数据的真实性，并且获取解密后的明文.
     * @param $encryptedData string 加密的用户数据
     * @param $iv string 与用户数据一同返回的初始向量
     * @param $data string 解密后的原文
     *  *    <li>-41001: encodingAesKey 非法</li>
     *    <li>-41003: aes 解密失败</li>
     *    <li>-41004: 解密后得到的buffer非法</li>
     *    <li>-41005: base64加密失败</li>
     *    <li>-41016: base64解密失败</li>
     * @return int 成功0，失败返回对应的错误码
     */
    private function decryptData($sessionKey, $encryptedData, $iv, &$data)
    {
        if (strlen($sessionKey) != 24) {
            return '-41001';
        }
        $aesKey = base64_decode($sessionKey);
        if (strlen($iv) != 24) {
            return '-41002';
        }
        $aesIV = base64_decode($iv);

        $aesCipher = base64_decode($encryptedData);
        $result = openssl_decrypt($aesCipher, "AES-128-CBC", $aesKey, 1, $aesIV);
        //var_dump($result);exit;
        $dataObj = json_decode($result);
        if ($dataObj  == NULL) {
            return '-41003';
        }
        //        $appid = config('-wxsite.wx_xcx_appid');
        //        if( $dataObj->watermark->appid != $appid )
        //        {
        //            return '-41003';
        //        }
        $data = $dataObj;
        return '0';
    }


    public function getOpenid(Request $request)
    {
        $appid = env('WX_XCX_APPID');
        $secret = env('WX_XCX_KEY');
        $jsCode = $request->js_code ?? '';
        $url = 'https://api.weixin.qq.com/sns/jscode2session?appid=' . $appid . '&secret=' . $secret . '&js_code=' . $jsCode . '&grant_type=authorization_code';
        $wx_data = json_decode(file_get_contents($url), true);
        if (isset($wx_data['errcode'])) {
            Log::add('请求微信接口异常', $wx_data);
            return $this->JsonResponse('', '请求微信接口异常', 201);
        }
        return $this->JsonResponse([
            'session_key' => $wx_data['session_key'],
            'openid' => $wx_data['openid']
        ]);
    }

    public function login(Request $request)
    {
        $code = $request->code ?? '';
        $iv = $request->iv ?? '';
        //$openId = $request->openid ?? '';
        $encryptedData = $request->encryptedData ?? '';

        $result = $this->codeToSession($code);
        $openId = $result['openid'];
        $session_key = $result['session_key'];

        $res = $this->decryptData($session_key, $encryptedData, $iv, $data);
        if ($res != 0) {
            return $this->JsonResponse('', '参数异常', 201);
        }
        $user = User::where(['phone' => $data->phoneNumber])->first();
        if (!$user) {
            $user = new User();
            $user->name = 'wx_' . uniqid();
            $user->openid = $openId;
            $user->phone = $data->phoneNumber;
            $user->save();
        }
        if ($user->openid != $openId) {
            $user->openid = $openId;
            $user->save();
        }
        //生成token
        $accessToken = 'Bearer ' . $user->createToken('Access-token')->plainTextToken;
        Log::add('用户--' . $user->id . '登录', ['token' => $accessToken]);
        return $this->JsonResponse([
            'Authorization' => $accessToken,

        ]);
    }

    public function logout(Request $request)
    {
        $request->user()->tokens()->delete();
        //PersonalAccessToken::where(['tokenable_id' => $request->user()->id])->delete();
        return $this->JsonResponse('');
    }

    private function codeToSession($code)
    {
        $appid = env('WX_XCX_APPID');
        $secret = env('WX_XCX_KEY');
        if (!$code) {
            $this->error('无效参数Code');
        }
        $url = 'https://api.weixin.qq.com/sns/jscode2session?appid=' . $appid . '&secret=' . $secret . '&js_code=' . $code . '&grant_type=authorization_code';
        $wx_data = json_decode(file_get_contents($url), true);
        if (isset($wx_data['errcode'])) {
            Log::add('请求微信接口异常', $wx_data);
            return $this->JsonResponse('', '请求微信接口异常', 201);
        }
        return $wx_data;
    }

    public function testLogin(Request $request)
    {
        $uid = $request->uid ?? 31;
        $user = User::find($uid);
        $accessToken = 'Bearer ' . $user->createToken('Access-token')->plainTextToken;
        return $this->JsonResponse(['Authorization' => $accessToken,]);
    }
}
