<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Handlers\QqCos;
use App\Handlers\FileUploadHandler;
use App\Models\Carousel;
use App\Models\User;
use App\Models\UserPermission;
use Illuminate\Http\Request;

class CarouselController extends BaseController
{
    public function getList()
    {
        $list = (new Carousel())->select("id", "imgUrl", "title", "status")
            ->where("status", 1)
            ->orderBy("id", "desc")
            ->limit(9)
            ->get();

        foreach ($list as $key => $val) {
            $list[$key]['imgUrl'] = ($val->imgUrl ? env('IMAGE_URL') . $val->imgUrl : "");
        }

        return  $this->JsonResponse($list);
    }
}
