<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

/**
 * api基类
 */
class BaseController extends Controller
{

    /**
     * 验证码有效时长
     * @var int
     */
    protected static $expire = 300;

    /**
     * 最大允许检测的次数
     * @var int
     */
    protected static $maxCheckNums = 10;

    /**
     * @param $data mixed 返回的数据
     * @param $msg string 状态码
     * @param $code int 返回的自定义信息
     * @return Response
     */
    protected function JsonResponse($data, string $msg = 'Success', int $code = 200): Response
    {
        //组建返回结果
        $result = [
            'code' => $code,
            'message' => $msg,
            'data' => $data,
        ];
        return response($result, 200);
    }

    public function checkcode($mobile, $code, $event = 'default')
    {
        $time = time() - self::$expire;
        $smsObj = DB::table("li_sms")->where(['mobile' => $mobile, 'event' => $event])
            ->orderBy('id', 'DESC')
            ->first();
        if ($smsObj) {
            $sms = get_object_vars($smsObj);
            if ($sms['createtime'] > $time && $sms['times'] <= self::$maxCheckNums) {
                $correct = $code == $sms['code'];
                if (!$correct) {
                    $smsObj->times = $smsObj->times + 1;
                    $smsObj->save();
                    return false;
                } else {
                    return true;
                }
            } else {
                // 过期则清空该手机验证码
                $this->flush($mobile, $event);
                return false;
            }
        } else {
            return false;
        }
    }

    public function flush($mobile, $event = 'default')
    {
        DB::table("li_sms")->where(['mobile' => $mobile, 'event' => $event])
            ->delete();

        return true;
    }
}
