<?php

namespace App\Http\Controllers\Api;

use App\Command\Log;
use App\Models\Article;
use Illuminate\Http\Request;

class ArticleController extends BaseController
{
    public function getList()
    {
        $page = $request->page ?? 1;
        $limit = $request->limit ?? 10;
        $cat_id = $request->cat_id ?? 0;

        $where = ['is_show' => 1];
        if ($cat_id) {
            $where['cat_id'] = $cat_id;
        }
        $sql = Article::where($where);
        $data = [
            'total' => $sql->count(),
            'total_page' => ceil($sql->count() / $limit),
            'list' => []
        ];
        $listData = $sql->offset(($page - 1) * $limit)->limit($limit)->orderBy('created_at', 'DESC')->get();
        if ($listData->toArray()) {
            foreach ($listData as $item) {
                $data['list'][] = [
                    'id' => $item->id,
                    'title' => $item->title,
                    'brief' => $item->brief,
                    'cover' => $item->cover ? env('IMAGE_URL') . $item->cover : '',
                    'content' => $item->content,
                    'created_at' => $item->created_at ? date("Y-m-d H:i:s", strtotime($item->created_at)) : '',
                ];
            }
        }
        return $this->JsonResponse($data);
    }

    public function getDetail(Request $request)
    {
        $aid = $request->aid ?? null;

        $aObj = Article::find($aid);
        if (!$aObj) {
            return $this->JsonResponse('', '参数错误', 201);
        }

        $data = [
            'id' => $aid,
            'title' => $aObj->title,
            'brief' => $aObj->brief ?? '',
            'content' => $aObj->content,
            'created_at' => $aObj->created_at ? date("Y-m-d H:i:s", strtotime($aObj->created_at)) : '',
        ];
        return $this->JsonResponse($data);
    }
}
