<?php

/**
 * 含有中文数组排序
 */
function utf8_array_asort(&$array)
{
    if (!isset($array) || !is_array($array)) {
        return false;
    }
    foreach ($array as $k => $v) {
        $array[$k] = iconv('UTF-8', 'GBK//IGNORE', $v);
    }
    asort($array);
    foreach ($array as $k => $v) {
        $array[$k] = iconv('GBK', 'UTF-8//IGNORE', $v);
    }
    return true;
}

/**
 * 生成随机字符串
 */
function generateRandomString($length = 10)
{
    $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
