<?php

namespace App\Admin\Renderable;


use App\Models\OrderGoods;
use App\Models\Good as GoodModel;
use App\Models\Category;
use App\Models\GoodSku;
use Dcat\Admin\Grid;
use Dcat\Admin\Grid\LazyRenderable;

class RenderGoodSku extends LazyRenderable
{
    public function grid(): Grid
    {
        // 获取外部传递的参数
        $gid = $this->payload['goods_id'] ?? [];

        return Grid::make(new GoodSku(), function (Grid $grid) use ($gid) {
            $grid->model()->where('goods_id', $gid);
            //规格	购买数量 折扣价	采购价	京东价	零售价	库存
            $grid->addTableClass(['table-text-center']);
            $grid->model()->where('goods_id', $gid);
            $grid->column('attr_val', '规格');
            $grid->column('cg_price', '代购价');
            $grid->column('market_price', '零售价');
            $grid->column('stock', '库存');

            $grid->disableCreateButton();
            $grid->disableRefreshButton();
            $grid->disablePagination();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableRowSelector();
            $grid->disableDeleteButton();
            $grid->disableActions();
            //屏蔽删除
            //$grid->actions(new DeleteService());
        });
    }
}
