<?php

namespace App\Admin\Renderable;


use App\Models\MerchantGoodSku;
use App\Models\Good as GoodModel;
use App\Models\Category;
use Dcat\Admin\Grid;
use Dcat\Admin\Grid\LazyRenderable;

class MerchantStoreSkuList extends LazyRenderable
{
    public function grid(): Grid
    {
        // 获取外部传递的参数

        $mgs_id = $this->payload['mgs_id'] ?? 0;

        return Grid::make(MerchantGoodSku::with(['attr']), function (Grid $grid) use ($mgs_id, $merid) {

            $grid->addTableClass(['table-text-center']);
            $grid->model()->where('mgs_id', $mgs_id);
            $grid->column('attr.attr_val', '规格');
            $grid->column('attr.market_price', '零售价');
            $grid->column('attr.cg_price', '代购价');
            $grid->column('stock', '剩余库存');

            $grid->disableCreateButton();
            $grid->disableRefreshButton();
            $grid->disablePagination();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableRowSelector();
            $grid->disableDeleteButton();
            $grid->disableActions();
            //屏蔽删除
            //$grid->actions(new DeleteService());
        });
    }
}
