<?php

namespace App\Admin\Forms;

use App\Models\GoodSku;
use App\Models\MerchantGoodsStore;
use App\Models\MerchantGoodSku;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Layout\Row;
use Dcat\Admin\Form\NestedForm;
use Dcat\Admin\Widgets\Table;
use Dcat\Admin\Widgets\Tool;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Illuminate\Support\Facades\DB;
//
class MerchantSubStoreForms extends Form implements LazyRenderable
{
  use LazyWidget;
  protected $modalId = 'show-current-user';

  /**
   * Handle the form request.
   *
   * @param array $input
   *
   * @return mixed
   */
  public function handle(array $input)
  {
    $goods_id = (int)$_POST['goods_id'];
    $mgs_id = (int)$_POST['mgs_id'];
    $attr_ids = $_POST['attr_id'];
    $stocks = $_POST['stock'];
    $sskuids = isset($_POST['sskuid']) ? $_POST['sskuid'] : [];
    if (!$goods_id || !$mgs_id || !$attr_ids || !$stocks) {
      return $this->response()->error('参数错误')->refresh();
    }

    if (!$sskuids) {
      return $this->response()->error('参数错误')->refresh();
    }
    $logData = [];
    foreach ($sskuids as $kk => $vv) {
      //商家规格数据
      $skuObj = MerchantGoodSku::find($vv);
      $store_num = (int)$stocks[$kk]; //减少库存数
      $diffnum = $skuObj->stock - $store_num; //减少差值
      if ($store_num && $diffnum >= 0) {
        $skuObj->stock = $diffnum;
        $skuObj->save();
        //记录操作日志
        $logData[$kk]['mgs_id'] = $mgs_id;
        $logData[$kk]['attr_id'] = $skuObj->attr_id;
        $logData[$kk]['goods_id'] = $goods_id;
        $logData[$kk]['change'] = -$store_num;
        $logData[$kk]['created_at'] = date('Y-m-d H:i:s');
      }
    }
    $this->addStoreLog($logData);



    return $this
      ->response()
      ->success('Processed successfully.')
      ->refresh();
  }

  private function addStoreLog($data = [])
  {
    if (!$data) {
      return true;
    }
    DB::table('merchant_store_sku_log')->insert($data);
  }

  /**
   * Build a form here.
   */
  public function form()
  {
    //$this->text('name')->required();
    // 异步加载的字段
    $this->html('<div class="row">
                        <div class="col-md-12">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="23%" style="text-align:center;">商品名称</th>
                                        <th width="23%" style="text-align:center;">商品规格</th>
                                        <th width="23%" style="text-align:center;">减少库存</th>
                                        <th width="23%" style="text-align:center;">剩余库存</th>
                                    </tr>
                                </thead>
                                <tbody id="tabletr2">
                                </tbody>
                            </table>
                        </div>
                    </div>');
  }



  /**
   * The data of the form.
   *
   * @return array
   */
  public function default()
  {
    return [
      'name'  => '6785678567',
      'email' => 'John.Doe@gmail.com',
    ];
  }
}
