<?php

namespace App\Admin\Forms;

use App\Models\GoodSku;
use App\Models\MerchantGoodsStore;
use App\Models\MerchantGoodSku;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Layout\Row;
use Dcat\Admin\Form\NestedForm;
use Dcat\Admin\Widgets\Table;
use Dcat\Admin\Widgets\Tool;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Illuminate\Support\Facades\DB;
//
class MerchantStoreForms extends Form implements LazyRenderable
{
  use LazyWidget;
  protected $modalId = 'show-current-user';

  /**
   * Handle the form request.
   *
   * @param array $input
   *
   * @return mixed
   */
  public function handle(array $input)
  {
    $goods_id = (int)$_POST['goods_id'];
    $mgs_id = (int)$_POST['mgs_id'];
    $attr_ids = $_POST['attr_id'];
    $stocks = $_POST['stock'];

    if (!$goods_id || !$mgs_id || !$attr_ids || !$stocks) {
      return $this->response()->error('参数错误')->refresh();
    }
    //商品库存信息
    $msgObj = MerchantGoodsStore::find($mgs_id);
    $merchant_id = $msgObj->merchant_id;
    $logData = [];

    foreach ($attr_ids as $kk => $vv) {
      $gskuObj = GoodSku::find($vv); //商品信息
      //获取商户库存信息
      $merStock = MerchantGoodSku::where(['goods_id' => $goods_id, 'attr_id' => $vv])->sum('stock');
      $surplusStock = $gskuObj->stock - $merStock; //可供库存数量
      $stockNum = ($surplusStock >= $stocks[$kk] && $stocks[$kk]) ? (int)$stocks[$kk] : 0;
      if ($stockNum) {
        //查下库存记录是否存在
        $skuObj = MerchantGoodSku::where(['mgs_id' => $mgs_id, 'goods_id' => $goods_id, 'attr_id' => $vv])->first();
        if ($skuObj) {
          $skuObj->stock += $stockNum;
          $skuObj->save();
        } else {
          $skuObj = new MerchantGoodSku();
          $skuObj->mgs_id = $mgs_id;
          $skuObj->merchant_id = $merchant_id;
          $skuObj->goods_id = $goods_id;
          $skuObj->attr_id = $vv;
          $skuObj->stock = $stockNum;
          $skuObj->save();
        }

        //记录操作日志
        $logData[$kk]['mgs_id'] = $mgs_id;
        $logData[$kk]['goods_id'] = $goods_id;
        $logData[$kk]['attr_id'] = $gskuObj->id;
        $logData[$kk]['change'] = $stockNum;
        $logData[$kk]['created_at'] = date('Y-m-d H:i:s');
      }
    }
    $this->addStoreLog($logData);

    return $this
      ->response()
      ->success('Processed successfully.')
      ->refresh();
  }

  private function addStoreLog($data = [])
  {
    if (!$data) {
      return true;
    }
    DB::table('merchant_store_sku_log')->insert($data);
  }

  /**
   * Build a form here.
   */
  public function form()
  {
    //$this->text('name')->required();
    //$this->email('email')->rules('email');

    // 异步加载的字段
    $this->html('<div class="row">
                        <div class="col-md-12">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="23%" style="text-align:center;">商品名称</th>
                                        <th width="23%" style="text-align:center;">商品规格</th>
                                        <th width="23%" style="text-align:center;">增加库存</th>
                                        <th width="23%" style="text-align:center;">剩余库存</th>
                                    </tr>
                                </thead>
                                <tbody id="tabletr">
                                    <!-- 表格数据 -->
                                    <!--<tr>
                                        <td style="text-align:center;vertical-align: middle;">数据1</td>
                                        <td style="text-align:center;vertical-align: middle;">蓝色、大号</td>
                                        <td ><input type="text" name="remark" value="" class="form-control field_remark _normal_" placeholder=""></td>
                                        <td style="text-align:center;vertical-align: middle;">123</td>
                                    </tr>-->
                                    <!-- 更多行数据 -->
                                </tbody>
                            </table>
                        </div>
                    </div>', $synchronized = false);
  }


  /**
   * The data of the form.
   *
   * @return array
   */
  public function default()
  {
    return [
      'name'  => '6785678567',
      'email' => 'John.Doe@gmail.com',
    ];
  }
}
