<?php

namespace App\Admin\Forms;

use App\Models\User;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Illuminate\Support\Facades\DB;

class GenerateUserCode extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {
        $num = (int)$input['num'];
        if ($num <= 0 || $num > 20) {
            $num = 20;
        }
        $data = [];
        $i = 0;
        $dcount = 0;
        do {
            $rndstr = generateRandomString(6);
            $exist = DB::table("li_check_number")->where("code", $rndstr)->count();
            if (!$exist) {
                array_push($data, $rndstr);
            }
            $dcount = count($data);
        } while ($i <= $num && $dcount != $num);
        // for ($i = 0; $i <= $num; $i++) {
        //     $rndstr = generateRandomString(6);
        //     $exist = DB::table("li_check_number")->where("code", $rndstr)->count();
        //     if (!$exist) {
        //         array_push($data, $rndstr);
        //     }
        // }
        if ($data) {
            foreach ($data as $code) {
                $addtime = date("Y-m-d H:i:s");
                DB::table("li_check_number")->insert(['code' => $code, 'created_at' => $addtime]);
            }
        }

        return $this->response()->success('确认成功')->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $this->text('num', '生成数量')->required()->help("生成20个以内随机编号（数字+大小写英文）");
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        // 获取外部传递参数
        return [];
    }
}
