<?php

namespace App\Admin\Forms;


use App\Models\User;
use App\Models\UserPermission;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Dcat\Admin\Widgets\Form;


class EditPermission extends Form  implements LazyRenderable
{
    use LazyWidget;
    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {

        $user = User::find($this->payload['id']);
        $user->permissions = $input['permissions'];
        if(!$user->save()){
            return $this
                ->response()
                ->error('修改用户权限失败')
                ->refresh();
        }
        return $this
            ->response()
            ->success('修改用户权限成功.')
            ->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $this->display('name','姓名');
        $this->display('phone','手机');
        $this->tree('permissions','权限')
            ->nodes(UserPermission::all()->toArray())
            ->treeState(false)
            ->saveAsJson();
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        $user = User::find($this->payload['id']);
        return [
            'permissions'  => $user->permissions,
            'name'  => $user->name,
            'phone' => $user->phone,
        ];
    }
}
