<?php

namespace App\Admin\Extensions;

use App\Models\Good as GoodModel;
use App\Models\Category as CategoryModel;
use App\Models\GoodSku as GoodSkuModel;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class GoodsExport implements FromCollection, WithHeadings
{
    private $row;
    private $data;
    private $headings;

    /**
     * TaskDataExcelExpoter constructor.
     * @param array $param 筛选条件
     * @param array $data 数据
     * @param array $headings 表头
     */
    public function __construct($param = [], $data = [], $headings = [])
    {
        //表头设定
        $headings = [[
            'goods_id' => '商品ID',
            'goods_name' => '商品名称',
            'catname' => '分类',
            'sku' => '规格信息',
            'product_no' => '型号',
            'material' => '材质',
            'box_size' => '箱规',
            'is_jd' => '是否京东自营',
            'supplier' => '供应商联系人',
            'su_phone' => '联系方式',
        ]];

        $data = $this->getList($param);

        $this->headings = $headings;
        $this->data = $data;
    }

    public function headings(): array
    {
        return $this->headings;
    }

    public function collection()
    {
        return collect($this->data);
    }


    // 获取导出数据
    public function getList($param)
    {
        $param = json_decode(json_encode($param), true);
        $prePage = $param['per_page'] ?? 200;
        $start = $param['start'] ?? 0;
        $goods_name = $param['search']['goods_name'] ?? '';
        $cat_id = $param['search']['cat_id'] ??  0;
        DB::enableQueryLog();
        $note_monitor = DB::table('li_goods');
        $where = [];
        if ($cat_id) {
            $where['cat_id'] = $cat_id;
        }
        if ($goods_name) {
            $where['goods_name'] = $goods_name;
        }

        $note_monitor = $note_monitor->where($where);

        // 计算列表总数
        $count = $note_monitor->count();

        // 获取列表
        $data = [];
        $list = $note_monitor->orderBy("id", 'desc')->limit($prePage)->offset($start)->get()->toArray();
        //$queries = DB::getQueryLog();
        foreach ($list as $key => $objVal) {
            $tmp = [];
            //ID
            $tmp['goods_id'] = $objVal->id;
            //名称
            $tmp['goods_name'] = $objVal->goods_name;
            //分类
            $catObj = CategoryModel::find($objVal->cat_id);
            $tmp['catname'] = $catObj ? $catObj->title : '';
            //规格
            $skufield = $objVal->sku ? json_decode($objVal->sku, true) : [];
            $attrsKey = isset($skufield['attrs']) ? array_keys($skufield['attrs']) : [];
            $attrsVal = isset($skufield['attrs']) ? array_values($skufield['attrs']) : [];
            $skuData =  isset($skufield['sku']) ? $skufield['sku'] : [];
            $skuStr = "";
            foreach ($skuData as $kk => $vv) {
                $attr_sn = isset($vv['attr_sn']) ? $vv['attr_sn'] : '';
                if (!$attr_sn) {
                    continue;
                }
                $gattr = DB::table("li_goods_sku")->where('goods_id', $objVal->id)->where('attr_sn', $attr_sn)->first();
                $skuStr .= " 规格：" . $gattr->attr_val . " 购买数量：" . $vv['numb'] . " 折扣价：" . $vv['price'] . " 采购价：" . $vv['cg_price'] . " 京东价：" . $vv['jd_price'] . " 市场价：" . $vv['market_price'] . " 库存：" . $vv['stock'] . "\n";
            }
            $tmp['sku'] = $skuStr;
            $tmp['product_no'] = $objVal->product_no;
            $tmp['material'] = $objVal->material;
            $tmp['box_size'] = $objVal->box_size;
            $tmp['is_jd'] = ($objVal->is_jd == 1) ? '京东自营' : '非京东自营';
            $tmp['supplier'] = $objVal->supplier;
            $tmp['su_phone'] = $objVal->su_phone;
            array_push($data, $tmp);
        }
        return $data;
    }
}
