<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\Verifier;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class VerifierController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Verifier(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->column('merchant_id');
            $grid->column('store_id');
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();
        
            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');
        
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Verifier(), function (Show $show) {
            $show->field('id');
            $show->field('merchant_id');
            $show->field('store_id');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Verifier(), function (Form $form) {
            $form->display('id');
            $form->text('merchant_id');
            $form->text('store_id');
        
            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
