<?php

namespace App\Admin\Controllers;

use App\Admin\Forms\EditPermission;
use App\Admin\Forms\updatePassword;
use App\Admin\Actions\UserBuyCode;
use Dcat\Admin\Grid\RowAction;
use App\Models\User;
use App\Models\UserPermission;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class UserController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(User::with(['shuser']), function (Grid $grid) {
            $grid->addTableClass(['table-text-center']);
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('avatar', '头像')->image('', 50, 50);
            $grid->column('name', '昵称');
            $grid->column('phone', '手机号');
            $grid->column('balance', '总金额');
            $grid->column('shuser.name', '所属上级');
            $grid->column('buycode', '直购码');
            //$grid->column('status', '状态')->switch('', true);
            $grid->column('created_at', '注册时间')->display(function ($val) {
                return date("Y-m-d H:i:s", strtotime($this->created_at));
            });

            $grid->disableCreateButton();
            $grid->disableViewButton();
            $grid->disableDeleteButton();
            $grid->enableDialogCreate();
            $grid->disableEditButton();
            //$grid->showQuickEditButton();
            //$grid->simplePaginate();

            $grid->actions(function (Grid\Displayers\Actions $actions) {
                $actions->append(new UserBuyCode($actions->row->id));
                // 添加一个按钮，并设置其属性
                $actions->append('<a href="/user-share?id=' . $this->id . '" alt="查看下级" target="_blank">查看下级</a>');

                // 或者使用 RowAction 来添加按钮
                //$actions->append(RowAction::make('自定义按钮')->route('custom.route'));
            });

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('name')->width(3);
                $filter->like('phone')->width(3);
                $filter->like('buycode', '直购码')->width(3);
                $filter->like('shuser.name', '所属上级')->width(3);
                //$filter->equal('role', '身份')->select(['1' => '用户', '2' => '代理商'])->width(3);
                $filter->between('created_at', '注册时间')->datetime()->width(4);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new User(), function (Show $show) {
            $show->field('id');
            $show->field('name');
            $show->field('avatar');
            $show->field('openid');
            $show->field('phone');
            $show->field('status');
            $show->field('role');
            $show->field('department');
            $show->field('email');
            $show->field('email_verified_at');
            $show->field('password');
            $show->field('remember_token');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new User(), function (Form $form) {
            $form->text('name', '昵称');
            $form->switch('status', '状态')->default(1);
            // $form->image('avatar', '头像')
            //     ->url('upload/user-avatar')
            //     ->deleteUrl('upload/delete-public-cos-file')
            //     ->autoUpload();

            // if ($form->isCreating()) {

            //     $form->mobile('phone', '手机号')->rules('required|unique:users,phone', ['required' => '手机号码不可为空', 'unique' => '此手机号码已存在，请重新填写']);
            //     $form->text('password', '密码');
            // }

            // if ($form->isCreating()) {
            //     $form->saving(function (Form $form) {
            //         $form->password = bcrypt($form->password);
            //     });
            // }
        });
    }
}
