<?php

namespace App\Admin\Controllers;

use App\Admin\Forms\EditPermission;
use App\Admin\Forms\updatePassword;
use App\Models\User;
use App\Models\UserPermission;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use App\Admin\Forms\UserCheckForm;

class UserCheckController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new User(), function (Grid $grid) {
            $grid->addTableClass(['table-text-center']);
            $grid->model()->where(['status' => 0])->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('avatar', '头像')->image('', 50, 50);
            $grid->column('company', '公司名称');
            $grid->column('phone', '手机号');
            $grid->column('status')
                ->display('点击审核')->modal(function (Grid\Displayers\Modal $modal) {
                    // 标题
                    $modal->title('点击审核');
                    // 自定义图标
                    $modal->icon('feather icon-edit');
                    // 传递当前行字段值
                    return UserCheckForm::make()->payload(['id' => $this->id]);
                });
            $grid->column('created_at', '注册时间')->display(function ($val) {
                return date("Y-m-d H:i:s", strtotime($this->created_at));
            });

            $grid->disableActions();
            $grid->disableCreateButton();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('phone')->width(3);
                $filter->like('company')->width(3);
                $filter->between('created_at', '创建时间')->datetime()->width(6);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new User(), function (Show $show) {
            $show->field('id');
            $show->field('name');
            $show->field('avatar');
            $show->field('openid');
            $show->field('phone');
            $show->field('status');
            $show->field('role');
            $show->field('department');
            $show->field('email');
            $show->field('email_verified_at');
            $show->field('password');
            $show->field('remember_token');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new User(), function (Form $form) {
            $form->text('name', '昵称');
            $form->text('company', '公司名称');
            $form->text('score', '积分');
            // $form->image('avatar', '头像')
            //     ->url('upload/user-avatar')
            //     ->deleteUrl('upload/delete-public-cos-file')
            //     ->autoUpload();

            // if ($form->isCreating()) {

            //     $form->mobile('phone', '手机号')->rules('required|unique:users,phone', ['required' => '手机号码不可为空', 'unique' => '此手机号码已存在，请重新填写']);
            //     $form->text('password', '密码');
            // }

            // if ($form->isCreating()) {
            //     $form->saving(function (Form $form) {
            //         $form->password = bcrypt($form->password);
            //     });
            // }
        });
    }
}
