<?php

namespace App\Admin\Controllers;


use Dcat\Admin\Traits\HasUploadedFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

class UploadController
{

    use HasUploadedFile;

    public function merchantUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/merchant/' . date("Ymd");
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }


    public function userUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/user';
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }


    public function goodsUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/goods/' . date("Ymd");
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }

    //商品规格图
    public function uploadSkuImage(Request $request)
    {
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            //$disk = Storage::disk('cosv5');
            // $ext = $file->getClientOriginalExtension();
            $disk = $this->disk();
            // $url = 'sku';
            // $res = $disk->put($url, $file);
            //获取文件扩展名
            $ext = $file->getClientOriginalExtension();
            $img  = Image::make($file->getRealPath())
                ->resize(640, null, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                })->encode($ext, 90);

            $dir     = '/goods/' . date("Ymd");
            $newName = md5(uniqid()) . '.' . $ext;

            $path   = "{$dir}/$newName";
            $result = $disk->put($path, $img);

            $url = $result ? $path : '';

            // 返回格式
            return ['url' => env('IMAGE_URL') . $url];
        }
        return [];
    }

    public function carouselUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/carousel';
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }

    public function articlelUpload()
    {
        $disk = $this->disk();

        // 判断是否是删除文件请求
        if ($this->isDeleteRequest()) {

            // 删除文件并响应
            return $this->deleteFileAndResponse();
        }

        // 获取上传的文件
        $file = $this->file();
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $img  = Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode($ext, 90);

        $dir     = '/article';
        $newName = md5(uniqid()) . '.' . $ext;

        $path   = "{$dir}/$newName";
        $result = $disk->put($path, $img);

        return $result
            ? $this->responseUploaded($path, $disk->url($path))
            : $this->responseErrorMessage('文件上传失败');
    }
}
