<?php

namespace App\Admin\Controllers;

use App\Admin\Forms\EditPermission;
use App\Admin\Forms\updatePassword;
use Dcat\Admin\Grid\RowAction;
use App\Models\User;
use App\Models\UserPermission;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Illuminate\Http\Request;
use Dcat\Admin\Http\Controllers\AdminController;

class ShareController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {

        $uid = request()->get('id');
        return Grid::make(User::with(['shuser']), function (Grid $grid) use ($uid) {
            $grid->addTableClass(['table-text-center']);
            $grid->model()->where('spuid', $uid)->orwhere('second_spuid', $uid)->orderBy('created_at', 'DESC');
            //$grid->column('id')->sortable();
            $grid->column('name', '昵称');
            $grid->column('phone', '手机号');
            $grid->column('created_at', '注册时间')->display(function ($val) {
                return date("Y-m-d H:i:s", strtotime($this->created_at));
            });

            $grid->disableCreateButton();
            $grid->disableViewButton();
            $grid->disableDeleteButton();
            $grid->enableDialogCreate();
            $grid->disableEditButton();
            $grid->disableActions();
            $grid->disableRowSelector();
            //$grid->simplePaginate();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('name', '昵称')->width(3);
                $filter->like('phone', '用户手机号')->width(3);
                $filter->equal('custom_field', '自定义字段')->select(['1' => '直推', '2' => '间推'])->where(function ($query) {
                    // 自定义查询逻辑
                    $sp_type = request('sp_type');
                    if ($sp_type == 1) {
                        $query->where('spuid', $sp_type);
                    } else {
                        $query->where('second_spuid', $sp_type);
                    }
                });
                //$filter->between('created_at', '注册时间')->datetime()->width(4);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new User(), function (Show $show) {
            $show->field('id');
            $show->field('name');
            $show->field('avatar');
            $show->field('openid');
            $show->field('phone');
            $show->field('status');
            $show->field('role');
            $show->field('department');
            $show->field('email');
            $show->field('email_verified_at');
            $show->field('password');
            $show->field('remember_token');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new User(), function (Form $form) {
            $form->text('name', '昵称');
            $form->switch('status', '状态')->default(1);
            // $form->image('avatar', '头像')
            //     ->url('upload/user-avatar')
            //     ->deleteUrl('upload/delete-public-cos-file')
            //     ->autoUpload();

            // if ($form->isCreating()) {

            //     $form->mobile('phone', '手机号')->rules('required|unique:users,phone', ['required' => '手机号码不可为空', 'unique' => '此手机号码已存在，请重新填写']);
            //     $form->text('password', '密码');
            // }

            // if ($form->isCreating()) {
            //     $form->saving(function (Form $form) {
            //         $form->password = bcrypt($form->password);
            //     });
            // }
        });
    }
}
