<?php

namespace App\Admin\Controllers;

use App\Models\MerchantStoreSkuLog;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class MerchantStoreSkuLogController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(MerchantStoreSkuLog::with(['goods', 'attr', 'mergs']), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('goods.goods_sn', '商品编号');
            $grid->column('goods.cover_img', '商品图片')->image('', 100, 100);
            $grid->column('goods.goods_name', '商品名称');
            $grid->column('attr.attr_val', '商品规格');
            $grid->column('change', '增减库存')->display(function ($val) {
                return $val > 0 ? "+" . $val : $val;
            });
            $grid->column('mergs.merchant_name', '商家名称');
            $grid->column('mergs.contacts', '联系人');
            $grid->column('created_at', '增减日期');

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel();
                $filter->like('goods.goods_name', '商品名称')->width(3);
                $filter->like('mergs.merchant_name', '商家名称')->width(3);
                $filter->like('mergs.contacts', '联系人')->width(3);
                $filter->between('created_at', '增减时间')->datetime()->width(6);
            });

            $grid->disableCreateButton();
            //$grid->disableRefreshButton();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableRowSelector();
            $grid->disableDeleteButton();
            $grid->disableActions();
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new MerchantStoreSkuLog(), function (Show $show) {
            $show->field('id');
            $show->field('goods_sn');
            $show->field('attr_name');
            $show->field('change');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new MerchantStoreSkuLog(), function (Form $form) {
            $form->display('id');
            $form->text('goods_sn');
            $form->text('attr_name');
            $form->text('change');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
